/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.grpcserver;

import com.xunlei.netty.grpcserver.interceptor.CatServerInterceptor;
import com.xunlei.netty.util.Log;
import com.xunlei.netty.util.NetUtil;
import com.xunlei.netty.util.NettyServerConfig;
import com.xunlei.netty.util.spring.BeanUtil;
import com.xunlei.netty.util.spring.SpringBootstrap;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GRPCServerFactory {
    private static final Logger log = Log.getLogger();
    @Autowired
    private NettyServerConfig config;
    private Server grpcServer;

    public void start() throws Exception {
        if (this.config.getListen_grpc_port() <= 0) {
            throw new Exception("GRPC \u670d\u52a1\u542f\u52a8\u7aef\u53e3\u5fc5\u987b\u5927\u4e8e0");
        }
        NetUtil.checkSocketPortBind(this.config.getListen_grpc_port());
        List<BindableService> bsList = this.getBindableServiceList();
        if (bsList == null || bsList.size() == 0) {
            throw new Exception("GRPC \u670d\u52a1\u542f\u52a8 \u672a\u627e\u5230\u670d\u52a1\u5b9e\u73b0\u7c7b");
        }
        ServerBuilder serverBuilder = ServerBuilder.forPort((int)this.config.getListen_grpc_port());
        for (BindableService bindableService : bsList) {
            serverBuilder.addService(ServerInterceptors.intercept((BindableService)bindableService, (ServerInterceptor[])new ServerInterceptor[]{new CatServerInterceptor()}));
        }
        this.grpcServer = serverBuilder.build();
        this.grpcServer.start();
    }

    private List<BindableService> getBindableServiceList() {
        ArrayList<BindableService> bsList = new ArrayList<BindableService>();
        for (String name : SpringBootstrap.getContext().getBeanDefinitionNames()) {
            Object obj = BeanUtil.getTypedBean(name);
            if (!(obj instanceof BindableService)) continue;
            bsList.add((BindableService)obj);
        }
        return bsList;
    }
}

