/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.consul.service;

import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import com.ecwid.consul.v1.agent.model.NewService;
import com.ecwid.consul.v1.health.model.HealthService;
import com.xunlei.netty.consul.ConsulFactory;
import com.xunlei.netty.consul.exception.ConsulRuntimeException;
import com.xunlei.netty.util.Log;
import com.xunlei.niux.common.util.IPUtil;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

public class ServiceClient {
    private static final Logger log = Log.getLogger();
    private static final ConcurrentHashMap<String, List<HealthService>> mapServiceList = new ConcurrentHashMap();
    private static final int CHECK_INTERVAL = 5;
    private static final int CHECK_TIMEOUT = 2;

    public NewService registerService(String serviceName, int httpPort, int soaPort) throws Exception {
        NewService service = null;
        Transaction t = Cat.newTransaction((String)"Consul", (String)"ServiceClient.registerService");
        try {
            if (StringUtils.isBlank((String)serviceName)) {
                throw new ConsulRuntimeException("\u670d\u52a1\u540d\u4e3a\u7a7a");
            }
            if (httpPort <= 0) {
                throw new ConsulRuntimeException("HTTP\u7aef\u53e3\u53f7\u5c0f\u4e8e\u7b49\u4e8e0");
            }
            String hostAddress = IPUtil.getLocalHostAddress();
            ConsulFactory.Env env = ConsulFactory.CONSUL_ENV;
            if (env == ConsulFactory.Env.PreRelease || env == ConsulFactory.Env.Release) {
                hostAddress = IPUtil.getLocalHostName() + ".sandai.net";
            }
            Cat.logEvent((String)"Consul.RegisterService.serviceName", (String)serviceName);
            Cat.logEvent((String)"Consul.RegisterService.hostAddress", (String)hostAddress);
            Cat.logEvent((String)"Consul.RegisterService.httpPort", (String)(httpPort + ""));
            Cat.logEvent((String)"Consul.RegisterService.soaPort", (String)(soaPort + ""));
            service = new NewService();
            service.setId(serviceName + "-" + hostAddress);
            service.setName(serviceName);
            service.setAddress(hostAddress);
            service.setPort(Integer.valueOf(soaPort));
            NewService.Check check = new NewService.Check();
            check.setHttp(String.format("http://%s:%d/echo", hostAddress, httpPort));
            check.setInterval("5s");
            check.setTimeout("2s");
            service.setCheck(check);
            ConsulFactory.getInstance().getConsulClient().agentServiceRegister(service);
            t.setStatus("0");
        }
        catch (Exception e) {
            t.setStatus((Throwable)e);
            log.error("Consul \u6ce8\u518c\u670d\u52a1[ServiceClient.registerService] \u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            t.complete();
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HealthService> getServiceList(String serviceName) {
        List csList = null;
        Transaction t = Cat.newTransaction((String)"Consul", (String)"ServiceClient.getServiceList");
        t.addData("serviceName", (Object)serviceName);
        try {
            if (StringUtils.isNotBlank((String)serviceName)) {
                if (mapServiceList.containsKey(serviceName)) {
                    csList = mapServiceList.get(serviceName);
                } else {
                    csList = (List)ConsulFactory.getInstance().getConsulClient().getHealthServices(serviceName, true, null).getValue();
                    mapServiceList.put(serviceName, csList);
                }
            }
            t.setStatus("0");
        }
        catch (Exception e) {
            t.setStatus((Throwable)e);
            log.error("Consul \u83b7\u53d6\u670d\u52a1\u5217\u8868[ServiceClient.getServiceList] \u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
        }
        finally {
            t.complete();
        }
        return csList;
    }

    public static ConcurrentHashMap<String, List<HealthService>> getMapServiceList() {
        return mapServiceList;
    }

    public static int getCheckInterval() {
        return 5;
    }

    public static int getCheckTimeout() {
        return 2;
    }
}

