/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.consul.loadbalance;

import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import com.ecwid.consul.v1.health.model.HealthService;
import com.xunlei.netty.consul.ConsulFactory;
import com.xunlei.netty.consul.loadbalance.ILoadBalance;
import com.xunlei.netty.util.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

public class RoundRobinLoadBalance
implements ILoadBalance {
    private static final Logger log = Log.getLogger();
    private static final ConcurrentHashMap<String, Integer> mapPos = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HealthService chooseByList(String serviceName, List<HealthService> serviceList) {
        HealthService service = null;
        if (StringUtils.isNotBlank((String)serviceName) && serviceList != null && serviceList.size() > 0) {
            Transaction t = Cat.newTransaction((String)"Consul", (String)"RoundRobinLoadBalance.chooseByList");
            t.addData("serviceName", (Object)serviceName);
            t.addData("serviceList", serviceList);
            try {
                ArrayList<HealthService> newServiceList = new ArrayList<HealthService>();
                newServiceList.addAll(serviceList);
                String string = ("LB_LockKey_" + serviceName).intern();
                synchronized (string) {
                    Integer pos = 0;
                    if (mapPos.containsKey(serviceName)) {
                        pos = mapPos.get(serviceName);
                    }
                    if (pos >= newServiceList.size()) {
                        pos = 0;
                    }
                    service = (HealthService)newServiceList.get(pos);
                    Integer n = pos;
                    Integer n2 = pos = Integer.valueOf(pos + 1);
                    mapPos.put(serviceName, pos);
                }
                t.setStatus("0");
            }
            catch (Exception e) {
                t.setStatus((Throwable)e);
                log.error("Consul \u9009\u62e9\u4e00\u4e2a\u670d\u52a1[RoundRobinLoadBalance.chooseByList] \u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            }
            finally {
                t.complete();
            }
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HealthService choose(String serviceName) {
        HealthService service = null;
        if (StringUtils.isNotBlank((String)serviceName)) {
            Transaction t = Cat.newTransaction((String)"Consul", (String)"RoundRobinLoadBalance.choose");
            t.addData("serviceName", (Object)serviceName);
            try {
                List<HealthService> serviceList = ConsulFactory.getInstance().getServiceList(serviceName);
                service = this.chooseByList(serviceName, serviceList);
                if (service != null) {
                    Cat.logEvent((String)"Consul.ChooseService.serviceId", (String)service.getService().getId());
                    Cat.logEvent((String)"Consul.ChooseService.serviceName", (String)service.getService().getService());
                    Cat.logEvent((String)"Consul.ChooseService.serviceAddress", (String)service.getService().getAddress());
                    Cat.logEvent((String)"Consul.ChooseService.servicePort", (String)(service.getService().getPort() + ""));
                }
                t.setStatus("0");
            }
            catch (Exception e) {
                t.setStatus((Throwable)e);
                log.error("Consul \u9009\u62e9\u4e00\u4e2a\u670d\u52a1[RoundRobinLoadBalance.choose] \u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            }
            finally {
                t.complete();
            }
        }
        return service;
    }
}

