/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.cache;

import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import com.xunlei.netty.util.NettyServerConfig;
import com.xunlei.netty.util.spring.AfterConfig;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

@Component
public class JRedisProxy {
    private static String jredisPropertiesUrl = "jredis.properties";
    private static JRedisProxy jRedisProxy = null;
    private static Object lock = new Object();
    private static Logger logger = LoggerFactory.getLogger((String)JRedisProxy.class.getName());
    @Autowired
    private NettyServerConfig nettyServerConfig;
    private Properties config = new Properties();
    private JedisPool pool;
    private String serverHost;
    private int serverPort;
    private int serverTimeout;
    private int maxTotal;
    private int maxIdle;
    private int maxWaitMillis;
    private static final String catMetricsType = "Cache.jredis";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JRedisProxy getInstance() {
        if (jRedisProxy == null) {
            Object object = lock;
            synchronized (object) {
                if (jRedisProxy == null) {
                    jRedisProxy = new JRedisProxy(jredisPropertiesUrl);
                }
            }
        }
        return jRedisProxy;
    }

    public JRedisProxy() {
    }

    public JRedisProxy(String jredisPropertiesUrl) {
        if (StringUtils.isNotBlank((String)jredisPropertiesUrl)) {
            System.out.println("jredis system\u8fde\u63a5 \u521d\u59cb\u5316");
            try {
                InputStream jredisProperties = JRedisProxy.class.getClassLoader().getResourceAsStream(jredisPropertiesUrl);
                if (jredisProperties != null) {
                    this.initJedisPool(jredisProperties);
                }
            }
            catch (Exception e) {
                System.out.println("jredis system\u8fde\u63a5\u521d\u59cb\u5316\u5931\u8d25");
                e.printStackTrace();
                logger.error("JRedisProxy\u521d\u59cb\u5316[JRedisProxy(jredisPropertiesUrl)].\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    private void initJedisPool(InputStream jredisProperties) throws Exception {
        this.config.load(jredisProperties);
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        this.maxTotal = Integer.parseInt(this.config.getProperty("maxActive", "1000"));
        this.maxIdle = Integer.parseInt(this.config.getProperty("maxIdle", "30"));
        this.maxWaitMillis = Integer.parseInt(this.config.getProperty("maxWait", "1000"));
        poolConfig.setMaxTotal(this.maxTotal);
        poolConfig.setMaxIdle(this.maxIdle);
        poolConfig.setMaxWaitMillis((long)this.maxWaitMillis);
        poolConfig.setTestOnBorrow(false);
        poolConfig.setTestOnReturn(false);
        this.serverHost = this.config.getProperty("host");
        this.serverPort = Integer.parseInt(this.config.getProperty("port", "6379"));
        this.serverTimeout = Integer.parseInt(this.config.getProperty("timeout", "2000"));
        this.pool = new JedisPool((GenericObjectPoolConfig)poolConfig, this.serverHost, this.serverPort, this.serverTimeout);
        logger.debug(String.format("JRedisProxy.\u521d\u59cb\u5316\u7ebf\u7a0b\u6c60[initJedisPool].\u6b63\u5e38\uff1aHost:%s,Port:%s,TimeOut:%s", this.serverHost, this.serverPort, this.serverTimeout));
    }

    public JedisPool getJedisPool() {
        return this.pool;
    }

    public String getServerHost() {
        return this.serverHost;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public int getServerTimeout() {
        return this.serverTimeout;
    }

    public int getMaxTotal() {
        return this.maxTotal;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public int getMaxWaitMillis() {
        return this.maxWaitMillis;
    }

    public String getJredisPropertiesUrl() {
        return jredisPropertiesUrl;
    }

    @AfterConfig
    private void initJRedisProxy() {
        if (StringUtils.isNotBlank((String)this.nettyServerConfig.getJredisPropertiesUrl())) {
            jredisPropertiesUrl = this.nettyServerConfig.getJredisPropertiesUrl();
        }
        logger.info("JRedisProxy\u670d\u52a1\u542f\u52a8\u65f6\u521d\u59cb\u5316\uff0c\u914d\u7f6e\u6587\u4ef6\u5730\u5740\uff1a" + jredisPropertiesUrl);
        jRedisProxy = JRedisProxy.getInstance();
    }

    private Transaction newTransaction(String metricsName) {
        Transaction t = Cat.newTransaction((String)catMetricsType, (String)metricsName);
        Cat.logEvent((String)"Cache.jredis.server", (String)this.serverHost);
        Cat.logEvent((String)"Cache.jredis.serverPort", (String)(this.serverPort + ""));
        Cat.logEvent((String)"Cache.jredis.serverTimeout", (String)(this.serverTimeout + ""));
        return t;
    }

    public String getKey(String prefixKey, String keyId) {
        String key = prefixKey;
        if (StringUtils.isNotBlank((String)keyId)) {
            key = StringUtils.isNotBlank((String)prefixKey) ? prefixKey + keyId : keyId;
        }
        return key;
    }

    public String[] getKey(String prefixKey, String ... keyIds) {
        String[] array = null;
        if (keyIds != null && keyIds.length > 0) {
            array = new String[keyIds.length];
            for (int i = 0; i < keyIds.length; ++i) {
                String keyId = keyIds[i];
                array[i] = this.getKey(prefixKey, keyId);
            }
        }
        return array;
    }

    public boolean set(String key, String value, int seconds) {
        return this.set(key, null, value, seconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set(String prefixKey, String keyId, String value, int seconds) {
        Jedis jedis = null;
        String key = this.getKey(prefixKey, keyId);
        if (StringUtils.isNotBlank((String)key) && StringUtils.isNotBlank((String)value)) {
            String metricsName = "[Method-setex] " + prefixKey;
            Transaction t = this.newTransaction(metricsName);
            t.addData(key, (Object)value);
            try {
                jedis = this.pool.getResource();
                jedis.setex(key, seconds, value);
                t.setStatus("0");
                logger.debug("\u8bbe\u7f6e\u7f13\u5b58[JRedisProxy.setex].\u6b63\u5e38\uff1akey=" + key + ",value=" + value + ",seconds=" + seconds);
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                t.setStatus((Throwable)e);
                logger.error("\u8bbe\u7f6e\u7f13\u5b58[JRedisProxy.setex].\u5f02\u5e38\uff1akey=" + key + ",value=" + value + ",seconds=" + seconds, (Throwable)e);
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
                t.complete();
            }
        }
        return false;
    }

    public Boolean setnx(String key, String value) {
        return this.setnx(key, null, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean setnx(String prefixKey, String keyId, String value) {
        Jedis jedis = null;
        String key = this.getKey(prefixKey, keyId);
        if (StringUtils.isNotBlank((String)key) && StringUtils.isNotBlank((String)value)) {
            String metricsName = "[Method-setnx] " + prefixKey;
            Transaction t = this.newTransaction(metricsName);
            t.addData(key, (Object)value);
            try {
                jedis = this.pool.getResource();
                Long result = jedis.setnx(key, value);
                t.setStatus("0");
                logger.debug("\u8bbe\u7f6e\u7f13\u5b58[JRedisProxy.setnx].\u6b63\u5e38\uff1akey=" + key + ",value=" + value);
                Boolean bl = result == 1L;
                return bl;
            }
            catch (Exception e) {
                t.setStatus((Throwable)e);
                logger.error("\u8bbe\u7f6e\u7f13\u5b58[JRedisProxy.setnx].\u5f02\u5e38\uff1akey=" + key + ",value=" + value, (Throwable)e);
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
                t.complete();
            }
        }
        return null;
    }

    public String getSet(String key, String value) {
        return this.getSet(key, null, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSet(String prefixKey, String keyId, String value) {
        String result = null;
        Jedis jedis = null;
        String key = this.getKey(prefixKey, keyId);
        if (StringUtils.isNotBlank((String)key) && StringUtils.isNotBlank((String)value)) {
            String metricsName = "[Method-getset] " + prefixKey;
            Transaction t = this.newTransaction(metricsName);
            t.addData(key, (Object)value);
            try {
                jedis = this.pool.getResource();
                result = jedis.getSet(key, value);
                t.setStatus("0");
                logger.debug("\u8bbe\u7f6e\u7f13\u5b58[JRedisProxy.getset].\u6b63\u5e38\uff1akey=" + key + ",newValue=" + value + ",oldValue=" + result);
            }
            catch (Exception e) {
                t.setStatus((Throwable)e);
                logger.error("\u8bbe\u7f6e\u7f13\u5b58[JRedisProxy.getset].\u5f02\u5e38\uff1akey=" + key + ",newValue=" + value + ",oldValue=" + result, (Throwable)e);
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
                t.complete();
            }
        }
        return result;
    }

    public String set(String key, String value, String nxxx, String expx, int time) {
        return this.set(key, null, value, nxxx, expx, time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String set(String prefixKey, String keyId, String value, String nxxx, String expx, int time) {
        String result = null;
        Jedis jedis = null;
        String key = this.getKey(prefixKey, keyId);
        if (StringUtils.isNotBlank((String)key) && StringUtils.isNotBlank((String)value)) {
            String metricsName = "[Method-set] " + prefixKey;
            Transaction t = this.newTransaction(metricsName);
            t.addData(key, (Object)value);
            try {
                jedis = this.pool.getResource();
                result = jedis.set(key, value, nxxx, expx, time);
                t.setStatus("0");
                logger.debug("\u8bbe\u7f6e\u7f13\u5b58[JRedisProxy.set].\u6b63\u5e38\uff1akey=" + key + ",value=" + value + ",nxxx=" + nxxx + ",expx=" + expx + ",time=" + time + ",result=" + result);
                String string = result;
                return string;
            }
            catch (Exception e) {
                t.setStatus((Throwable)e);
                logger.error("\u8bbe\u7f6e\u7f13\u5b58[JRedisProxy.set].\u5f02\u5e38\uff1akey=" + key + ",value=" + value + ",nxxx=" + nxxx + ",expx=" + expx + ",time=" + time + ",result=" + result, (Throwable)e);
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
                t.complete();
            }
        }
        return result;
    }

    public boolean set(String key, String value) {
        return this.set(key, null, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set(String prefixKey, String keyId, String value) {
        Jedis jedis = null;
        String key = this.getKey(prefixKey, keyId);
        if (StringUtils.isNotBlank((String)key) && StringUtils.isNotBlank((String)value)) {
            String metricsName = "[Method-set] " + prefixKey;
            Transaction t = this.newTransaction(metricsName);
            t.addData(key, (Object)value);
            try {
                jedis = this.pool.getResource();
                jedis.set(key, value);
                t.setStatus("0");
                logger.debug("\u8bbe\u7f6e\u7f13\u5b58\uff08\u6c38\u4e0d\u8fc7\u671f\uff09[JRedisProxy.set].\u6b63\u5e38\uff1akey=" + key + ",value=" + value);
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                t.setStatus((Throwable)e);
                logger.error("\u8bbe\u7f6e\u7f13\u5b58\uff08\u6c38\u4e0d\u8fc7\u671f\uff09[JRedisProxy.set].\u5f02\u5e38\uff1akey=" + key + ",value=" + value, (Throwable)e);
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
                t.complete();
            }
        }
        return false;
    }

    public String get(String key) {
        return this.get(key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String prefixKey, String keyId) {
        String value = null;
        Jedis jedis = null;
        String key = this.getKey(prefixKey, keyId);
        String metricsName = "[Method-get] " + prefixKey;
        Transaction t = this.newTransaction(metricsName);
        try {
            jedis = this.pool.getResource();
            value = jedis.get(key);
            t.addData(key, (Object)value);
            if (value == null) {
                Cat.logEvent((String)catMetricsType, (String)(metricsName + ":missed"));
            }
            t.setStatus("0");
            logger.debug("\u83b7\u53d6\u7f13\u5b58[JRedisProxy.get].\u6b63\u5e38\uff1akey=" + key + ",value=" + value);
        }
        catch (Exception e) {
            t.setStatus((Throwable)e);
            logger.error("\u83b7\u53d6\u7f13\u5b58[JRedisProxy.get].\u5f02\u5e38\uff1akey=" + key + ",value=" + value, (Throwable)e);
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
            t.complete();
        }
        return value;
    }

    public List<String> mget(String ... keys) {
        return this.mget((String)null, keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> mget(String prefixKey, String ... keyIds) {
        List value = null;
        Jedis jedis = null;
        String[] keys = this.getKey(prefixKey, keyIds);
        String metricsName = "[Method-mget] " + prefixKey;
        Transaction t = this.newTransaction(metricsName);
        try {
            jedis = this.pool.getResource();
            value = jedis.mget(keys);
            t.addData(keys + "", (Object)value);
            t.setStatus("0");
            logger.debug("\u6279\u91cf\u83b7\u53d6\u7f13\u5b58[JRedisProxy.mget].\u6b63\u5e38\uff1akey=" + keys + ",value=" + value);
        }
        catch (Exception e) {
            t.setStatus((Throwable)e);
            logger.error("\u6279\u91cf\u83b7\u53d6\u7f13\u5b58[JRedisProxy.mget].\u5f02\u5e38\uff1akey=" + keys + ",value=" + value, (Throwable)e);
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
            t.complete();
        }
        return value;
    }

    public void del(String key) {
        this.del(key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void del(String prefixKey, String keyId) {
        Jedis jedis = null;
        String key = this.getKey(prefixKey, keyId);
        String metricsName = "[Method-del] " + prefixKey;
        Transaction t = this.newTransaction(metricsName);
        try {
            jedis = this.pool.getResource();
            jedis.del(key);
            t.addData("DelKey", (Object)key);
            t.setStatus("0");
            logger.debug("\u5220\u9664\u7f13\u5b58[JRedisProxy.del].\u6b63\u5e38\uff1akey=" + key);
        }
        catch (Exception e) {
            t.setStatus((Throwable)e);
            logger.error("\u5220\u9664\u7f13\u5b58[JRedisProxy.del].\u5f02\u5e38\uff1akey=" + key, (Throwable)e);
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
            t.complete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expire(String prefixKey, String keyId, int seconds) {
        Jedis jedis = null;
        String key = this.getKey(prefixKey, keyId);
        String metricsName = "[Method-expire] " + prefixKey;
        Transaction t = this.newTransaction(metricsName);
        try {
            jedis = this.pool.getResource();
            jedis.expire(key, seconds);
            t.addData("expireKey", (Object)key);
            t.setStatus("0");
            logger.debug("\u8bbe\u7f6e\u7f13\u5b58\u8fc7\u671f\u65f6\u95f4[JRedisProxy.expire].\u6b63\u5e38\uff1akey=" + key);
        }
        catch (Exception e) {
            t.setStatus((Throwable)e);
            logger.error("\u8bbe\u7f6e\u7f13\u5b58\u8fc7\u671f\u65f6\u95f4[JRedisProxy.expire].\u5f02\u5e38\uff1akey=" + key, (Throwable)e);
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
            t.complete();
        }
    }

    public boolean exists(String key) {
        return this.exists(key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String prefixKey, String keyId) {
        Jedis jedis = null;
        String key = this.getKey(prefixKey, keyId);
        String metricsName = "[Method-exists] " + prefixKey;
        Transaction t = this.newTransaction(metricsName);
        try {
            jedis = this.pool.getResource();
            long ttl = jedis.ttl(key);
            t.addData("ExistsKey", (Object)key);
            t.setStatus("0");
            logger.debug("\u7f13\u5b58\u662f\u5426\u5b58\u5728[JRedisProxy.exists].\u6b63\u5e38\uff1akey=" + key);
            if (ttl > 0L) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            t.setStatus((Throwable)e);
            logger.error("\u7f13\u5b58\u662f\u5426\u5b58\u5728[JRedisProxy.exists].\u5f02\u5e38\uff1akey=" + key, (Throwable)e);
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
            t.complete();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> keys(String pattern) {
        Jedis jedis = null;
        Set result = null;
        String metricsName = "[Method-keys] " + pattern;
        Transaction t = this.newTransaction(metricsName);
        try {
            jedis = this.pool.getResource();
            result = jedis.keys(pattern);
            t.addData("pattern", (Object)pattern);
            t.setStatus("0");
            logger.debug("\u83b7\u53d6Key\u5217\u8868[JRedisProxy.keys].\u6b63\u5e38\uff1apattern=" + pattern);
        }
        catch (Exception e) {
            t.setStatus((Throwable)e);
            logger.error("\u83b7\u53d6Key\u5217\u8868[JRedisProxy.keys].\u5f02\u5e38\uff1apattern=" + pattern, (Throwable)e);
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
            t.complete();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zadd(String prefixKey, String keyId, long score, String member) {
        Jedis jedis = null;
        String key = this.getKey(prefixKey, keyId);
        if (StringUtils.isNotBlank((String)key) && StringUtils.isNotBlank((String)member)) {
            String metricsName = "[Method-zadd] " + prefixKey;
            Transaction t = this.newTransaction(metricsName);
            t.addData(key, (Object)("score=" + score + ",member=" + member));
            try {
                jedis = this.pool.getResource();
                jedis.zadd(key, (double)score, member);
                t.setStatus("0");
                logger.debug("\u8bbe\u7f6e\u7f13\u5b58[JRedisProxy.zadd].\u6b63\u5e38\uff1akey=" + key + ",score=" + score + ",member=" + member);
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                t.setStatus((Throwable)e);
                logger.error("\u8bbe\u7f6e\u7f13\u5b58[JRedisProxy.zadd].\u5f02\u5e38\uff1akey=" + key + ",score=" + score + ",member=" + member, (Throwable)e);
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
                t.complete();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zrem(String prefixKey, String keyId, String ... members) {
        Jedis jedis = null;
        String key = this.getKey(prefixKey, keyId);
        if (StringUtils.isNotBlank((String)key) && members != null) {
            String metricsName = "[Method-zrem] " + prefixKey;
            Transaction t = this.newTransaction(metricsName);
            t.addData(key, (Object)("members=" + members));
            try {
                jedis = this.pool.getResource();
                jedis.zrem(key, members);
                t.setStatus("0");
                logger.debug("\u8bbe\u7f6e\u7f13\u5b58[JRedisProxy.zrem].\u6b63\u5e38\uff1akey=" + key + ",members=" + members);
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                t.setStatus((Throwable)e);
                logger.error("\u8bbe\u7f6e\u7f13\u5b58[JRedisProxy.zrem].\u5f02\u5e38\uff1akey=" + key + ",members=" + members, (Throwable)e);
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
                t.complete();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zremrangeByScore(String prefixKey, String keyId, long min, long max) {
        Jedis jedis = null;
        String key = this.getKey(prefixKey, keyId);
        if (StringUtils.isNotBlank((String)key)) {
            String metricsName = "[Method-zremrangeByScore] " + prefixKey;
            Transaction t = this.newTransaction(metricsName);
            t.addData(key, (Object)("min=" + min + ",max=" + max));
            try {
                jedis = this.pool.getResource();
                jedis.zremrangeByScore(key, (double)min, (double)max);
                t.setStatus("0");
                logger.debug("\u8bbe\u7f6e\u7f13\u5b58[JRedisProxy.zremrangeByScore].\u6b63\u5e38\uff1akey=" + key + ",min=" + min + ",max=" + max);
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                t.setStatus((Throwable)e);
                logger.error("\u8bbe\u7f6e\u7f13\u5b58[JRedisProxy.zremrangeByScore].\u5f02\u5e38\uff1akey=" + key + ",min=" + min + ",max=" + max, (Throwable)e);
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
                t.complete();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zremrangebyrank(String prefixKey, String keyId, long start, long stop) {
        Jedis jedis = null;
        String key = this.getKey(prefixKey, keyId);
        if (StringUtils.isNotBlank((String)key)) {
            String metricsName = "[Method-zremrangebyrank] " + prefixKey;
            Transaction t = this.newTransaction(metricsName);
            t.addData(key, (Object)("min=" + start + ",max=" + stop));
            try {
                jedis = this.pool.getResource();
                jedis.zremrangeByRank(key, start, stop);
                t.setStatus("0");
                logger.debug("\u8bbe\u7f6e\u7f13\u5b58[JRedisProxy.zremrangebyrank].\u6b63\u5e38\uff1akey=" + key + ",min=" + start + ",max=" + stop);
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                t.setStatus((Throwable)e);
                logger.error("\u8bbe\u7f6e\u7f13\u5b58[JRedisProxy.zremrangebyrank].\u5f02\u5e38\uff1akey=" + key + ",min=" + start + ",max=" + stop, (Throwable)e);
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
                t.complete();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long zcount(String prefixKey, String keyId, double min, double max) {
        long result = 0L;
        Jedis jedis = null;
        String key = this.getKey(prefixKey, keyId);
        if (StringUtils.isNotBlank((String)key)) {
            String metricsName = "[Method-zcount] " + prefixKey;
            Transaction t = this.newTransaction(metricsName);
            t.addData(key, (Object)("min=" + min + ",max=" + max + ",min=" + min + ",max=" + max));
            try {
                jedis = this.pool.getResource();
                result = jedis.zcount(key, min, max);
                t.setStatus("0");
                logger.debug("\u8bbe\u7f6e\u7f13\u5b58[JRedisProxy.zcount].\u6b63\u5e38\uff1akey=" + key + ",min=" + min + ",max=" + max + ",min=" + min + ",max=" + max);
                long l = result;
                return l;
            }
            catch (Exception e) {
                t.setStatus((Throwable)e);
                logger.error("\u8bbe\u7f6e\u7f13\u5b58[JRedisProxy.zcount].\u5f02\u5e38\uff1akey=" + key + ",min=" + min + ",max=" + max + ",min=" + min + ",max=" + max, (Throwable)e);
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
                t.complete();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> zrange(String prefixKey, String keyId, long min, long max) {
        Set<String> result = new HashSet<String>();
        Jedis jedis = null;
        String key = this.getKey(prefixKey, keyId);
        if (StringUtils.isNotBlank((String)key)) {
            String metricsName = "[Method-zrange] " + prefixKey;
            Transaction t = this.newTransaction(metricsName);
            t.addData(key, (Object)("min=" + min + ",max=" + max + ",min=" + min + ",max=" + max));
            try {
                jedis = this.pool.getResource();
                result = jedis.zrange(key, min, max);
                t.setStatus("0");
                logger.debug("\u8bbe\u7f6e\u7f13\u5b58[JRedisProxy.zrange].\u6b63\u5e38\uff1akey=" + key + ",min=" + min + ",max=" + max + ",min=" + min + ",max=" + max);
                Set<String> set = result;
                return set;
            }
            catch (Exception e) {
                t.setStatus((Throwable)e);
                logger.error("\u8bbe\u7f6e\u7f13\u5b58[JRedisProxy.zrange].\u5f02\u5e38\uff1akey=" + key + ",min=" + min + ",max=" + max + ",min=" + min + ",max=" + max, (Throwable)e);
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
                t.complete();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> zrangeByScore(String prefixKey, String keyId, double min, double max, int offset, int count) {
        Set<String> result = new HashSet<String>();
        Jedis jedis = null;
        String key = this.getKey(prefixKey, keyId);
        if (StringUtils.isNotBlank((String)key)) {
            String metricsName = "[Method-zrangeByScore] " + prefixKey;
            Transaction t = this.newTransaction(metricsName);
            t.addData(key, (Object)("min=" + min + ",max=" + max + ",offset=" + offset + ",count=" + count));
            try {
                jedis = this.pool.getResource();
                result = jedis.zrangeByScore(key, min, max, offset, count);
                t.setStatus("0");
                logger.debug("\u8bbe\u7f6e\u7f13\u5b58[JRedisProxy.zrangeByScore].\u6b63\u5e38\uff1akey=" + key + ",min=" + min + ",max=" + max + ",offset=" + offset + ",count=" + count);
                Set<String> set = result;
                return set;
            }
            catch (Exception e) {
                t.setStatus((Throwable)e);
                logger.error("\u8bbe\u7f6e\u7f13\u5b58[JRedisProxy.zrangeByScore].\u5f02\u5e38\uff1akey=" + key + ",min=" + min + ",max=" + max + ",offset=" + offset + ",count=" + count, (Throwable)e);
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
                t.complete();
            }
        }
        return result;
    }

    public int incrAndRtnKeyTimes(String key, int expireSecond) {
        return this.incrAndRtnKeyTimes(key, null, expireSecond);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int incrAndRtnKeyTimes(String prefixKey, String keyId, int expireSecond) {
        int value = 0;
        Jedis jedis = null;
        String key = this.getKey(prefixKey, keyId);
        if (StringUtils.isNotBlank((String)key)) {
            String metricsName = "[Method-incrAndRtnKeyTimes] " + prefixKey;
            Transaction t = this.newTransaction(metricsName);
            t.addData(key, (Object)("expireSecond=" + expireSecond));
            try {
                jedis = this.pool.getResource();
                jedis.incr(key);
                jedis.expire(key, expireSecond);
                value = Integer.valueOf(jedis.get(key));
                t.setStatus("0");
                logger.debug("\u8bbe\u7f6e\u7f13\u5b58[JRedisProxy.incrAndRtnKeyTimes].\u6b63\u5e38\uff1akey=" + key + ",expireSecond=" + expireSecond + ",value=" + value);
            }
            catch (Exception e) {
                t.setStatus((Throwable)e);
                logger.error("\u8bbe\u7f6e\u7f13\u5b58[JRedisProxy.incrAndRtnKeyTimes].\u6b63\u5e38\uff1akey=" + key + ",expireSecond=" + expireSecond + ",value=" + value, (Throwable)e);
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
                t.complete();
            }
        }
        return value;
    }
}

