/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty;

import com.xunlei.netty.consul.ConsulFactory;
import com.xunlei.netty.grpcserver.GRPCServerFactory;
import com.xunlei.netty.httpserver.HttpServerPipelineFactory;
import com.xunlei.netty.httpserver.component.AbstractPageDispatcher;
import com.xunlei.netty.soaserver.SOAServerPipelineFactory;
import com.xunlei.netty.soaserver.component.BaseSOAPageDispatcher;
import com.xunlei.netty.util.IPAuthenticator;
import com.xunlei.netty.util.Log;
import com.xunlei.netty.util.NetUtil;
import com.xunlei.netty.util.NettyServerConfig;
import com.xunlei.netty.util.NioSocketBootstrapFactory;
import com.xunlei.netty.util.spring.BeanUtil;
import com.xunlei.netty.util.spring.SpringBootstrap;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import javax.annotation.Resource;
import org.jboss.netty.bootstrap.Bootstrap;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.logging.Slf4JLoggerFactory;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class BootstrapFactory {
    private static final Logger log = Log.getLogger();
    public static ApplicationContext CONTEXT;
    @Autowired
    private NettyServerConfig config;
    private Runnable initialRunnable = null;
    private Runnable shutdownRunanble = null;
    @Autowired
    private AbstractPageDispatcher pageDispatcher;
    @Autowired
    private BaseSOAPageDispatcher soaBasePageDispatcher;
    private NioServerSocketChannelFactory serverSocketChannelFactory;
    @Resource
    private HttpServerPipelineFactory httpServerPipelineFactory;
    @Resource
    private SOAServerPipelineFactory soaServerPipelineFactory;
    @Resource
    private GRPCServerFactory grpcServerFactory;

    public static ApplicationContext main(String[] args, Runnable initialRunnable, Runnable shutdownRunnalbe, String ... springConfigLocations) throws Exception {
        log.debug("Netty\u670d\u52a1.\u5f15\u5bfc\u7a0b\u5e8f.\u5f00\u59cb");
        try {
            long before = System.currentTimeMillis();
            CONTEXT = SpringBootstrap.load(springConfigLocations);
            System.err.println("----->loadContext      [" + (System.currentTimeMillis() - before) + "MS]");
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
        BootstrapFactory bootstrapFactory = (BootstrapFactory)BeanUtil.getTypedBean("bootstrapFactory");
        bootstrapFactory.initialRunnable = initialRunnable;
        bootstrapFactory.shutdownRunanble = shutdownRunnalbe;
        if (BootstrapFactory.isArgWhat(args, "stop", "shutdown")) {
            System.exit(0);
        } else {
            log.debug("Netty\u670d\u52a1.\u670d\u52a1\u542f\u52a8.\u5f00\u59cb");
            bootstrapFactory.start();
            log.debug("Netty\u670d\u52a1.\u670d\u52a1\u542f\u52a8.\u7ed3\u675f");
        }
        log.debug("Netty\u670d\u52a1.\u5f15\u5bfc\u7a0b\u5e8f.\u7ed3\u675f");
        return CONTEXT;
    }

    public static ApplicationContext main(String[] args, Runnable initialRunnable, String ... springConfigLocations) throws Exception {
        return BootstrapFactory.main(args, initialRunnable, null, springConfigLocations);
    }

    public static ApplicationContext main(String[] args, String ... springConfigLocations) throws Exception {
        return BootstrapFactory.main(args, null, null, springConfigLocations);
    }

    private void start() throws Exception {
        try {
            this.initEnv();
            this.initOutter();
            this.initHttpServer();
            this.initSOAServer();
            this.initGRPCServer();
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(-1);
        }
    }

    private void initEnv() throws Exception {
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new Slf4JLoggerFactory());
        IPAuthenticator.setBusinessWhiteIp(this.config.getIpWhiteList());
        IPAuthenticator.reload();
        if (this.config.isConsulIsEnable()) {
            String serviceName = this.config.getConsulServiceName();
            int httpPort = this.config.getListen_port();
            int grpcPort = this.config.getListen_grpc_port();
            ConsulFactory.getInstance().registerService(serviceName, httpPort, grpcPort);
        }
        this.serverSocketChannelFactory = new NioServerSocketChannelFactory((Executor)NettyServerConfig.bossExecutor, (Executor)NettyServerConfig.workerExecutor, this.config.getRealWorkerCount());
    }

    private void initOutter() {
        if (this.initialRunnable != null) {
            long before = System.currentTimeMillis();
            this.initialRunnable.run();
            System.err.println("----->initialRunnable  [" + (System.currentTimeMillis() - before) + "MS]");
        }
    }

    private void initHttpServer() throws Exception {
        int port = this.config.getListen_port();
        try {
            if (port > 0) {
                long beginBind = System.currentTimeMillis();
                this.pageDispatcher.init();
                ServerBootstrap serverBootstrap = new ServerBootstrap((ChannelFactory)this.serverSocketChannelFactory);
                serverBootstrap.setPipelineFactory((ChannelPipelineFactory)this.httpServerPipelineFactory.rebuildPipeline());
                NetUtil.checkSocketPortBind(port);
                this.bindAndBootstrapOptions(port, serverBootstrap);
                System.err.println("----->bindHttpPort   [" + port + "]  [" + (System.currentTimeMillis() - beginBind) + "MS]");
                System.err.println("HTTP\u670d\u52a1\u5668\u542f\u52a8\u5b8c\u6bd5.(port[" + port + "])");
            }
        }
        catch (Exception e) {
            System.err.println("HTTP\u670d\u52a1\u5668\u542f\u52a8\u5931\u8d25.(port[" + port + "]) ERROR:" + e.getMessage());
            throw e;
        }
    }

    private void initSOAServer() throws Exception {
        int soaPort = this.config.getListen_soa_port();
        try {
            if (soaPort > 0) {
                long beginBind = System.currentTimeMillis();
                this.soaBasePageDispatcher.init();
                ServerBootstrap serverBootstrap = new ServerBootstrap((ChannelFactory)this.serverSocketChannelFactory);
                serverBootstrap.setPipelineFactory((ChannelPipelineFactory)this.soaServerPipelineFactory.rebuildPipeline());
                NetUtil.checkSocketPortBind(soaPort);
                this.bindAndBootstrapOptions(soaPort, serverBootstrap);
                System.err.println("----->bindSOAPort   [" + soaPort + "]  [" + (System.currentTimeMillis() - beginBind) + "MS]");
                System.err.println("SOA\u670d\u52a1\u5668\u542f\u52a8\u5b8c\u6bd5.(port[" + soaPort + "])");
            }
        }
        catch (Exception e) {
            System.err.println("SOA\u670d\u52a1\u5668\u542f\u52a8\u5931\u8d25.(port[" + soaPort + "]) ERROR:" + e.getMessage());
            throw e;
        }
    }

    private void initGRPCServer() throws Exception {
        int grpcPort = this.config.getListen_grpc_port();
        try {
            if (grpcPort > 0) {
                long beginBind = System.currentTimeMillis();
                this.grpcServerFactory.start();
                System.err.println("----->bindGRPCPort   [" + grpcPort + "]  [" + (System.currentTimeMillis() - beginBind) + "MS]");
                System.err.println("GRPC\u670d\u52a1\u5668\u542f\u52a8\u5b8c\u6bd5.(port[" + grpcPort + "])");
            }
        }
        catch (Exception e) {
            System.err.println("GRPC\u670d\u52a1\u5668\u542f\u52a8\u5931\u8d25.(port[" + grpcPort + "]) ERROR:" + e.getMessage());
            throw e;
        }
    }

    private void bindAndBootstrapOptions(int port, ServerBootstrap serverBootstrap) {
        if (port > 0) {
            NioSocketBootstrapFactory.setBootstrapOptions((Bootstrap)serverBootstrap, this.config.getConnectTimeoutMillis(), this.config.getReceiveBufferSize(), this.config.getSendBufferSize());
            serverBootstrap.bind((SocketAddress)new InetSocketAddress(port));
        }
    }

    private static boolean isArgWhat(String[] args, String ... what) {
        if (args == null || args.length == 0) {
            return false;
        }
        String arg = args[0].toLowerCase();
        for (String w : what) {
            if (arg.indexOf(w) < 0) continue;
            return true;
        }
        return false;
    }

    public boolean isStop() {
        return false;
    }
}

