/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.uniononlinepay.util;

import com.unionpay.mpi.HttpClient;
import com.unionpay.mpi.MpiUtil;
import com.xunlei.uniononlinepay.constant.UnionPayRes;
import com.xunlei.uniononlinepay.dictonary.UnionDataDictonary;
import com.xunlei.uniononlinepay.exception.UnionPayException;
import com.xunlei.uniononlinepay.util.FaceFileReader;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnionPayUtil {
    private static Logger log = LoggerFactory.getLogger(UnionPayUtil.class);
    public static final String ENCODING = "UTF-8";
    public static final String[] EXPPARAM = new String[]{"certId", "signature"};

    public static Map<String, String> getMapFromParams(UnionDataDictonary data) throws Exception {
        String faceFileName = data.getFaceFileName();
        HashMap<String, String> res = new HashMap<String, String>();
        Map<String, String> params = FaceFileReader.getMustParamMap(faceFileName);
        log.info("\u63a5\u53e3\u540d:" + faceFileName + ",\u4e00\u5171\u9700\u8981\u53d1\u9001" + params.size() + "\u4e2a\u53c2\u6570");
        for (String param : params.keySet()) {
            String dvalue = params.get(param);
            Field field = UnionDataDictonary.class.getDeclaredField(param);
            field.setAccessible(true);
            String value = (String)field.get(data);
            if (value == null && !UnionPayUtil.isExpParam(param)) {
                if (dvalue != null && !"".equals(dvalue)) {
                    res.put(param, dvalue);
                    continue;
                }
                String message = "according to faceFile[" + faceFileName + "] param [" + param + "] can not be null!";
                throw new UnionPayException(UnionPayRes.RTN000002.getCode(), message);
            }
            res.put(param, value);
        }
        MpiUtil.sign(res, (String)ENCODING);
        return res;
    }

    public static Map<String, String> unionHttpPost(String url, Map<String, String> params, String encoding) throws Exception {
        log.info("======invoking url[" + url + "]" + "sending params" + params + " using encoding[" + encoding + "]=======");
        HttpClient hc = new HttpClient(url, 5000, 30000);
        int status = hc.send(params, encoding);
        if (200 == status) {
            String result = hc.getResult();
            log.info("\n=======Url return result[" + result + "]========");
            if (result != null && !"".equals(result)) {
                Map resData = MpiUtil.coverResultString2Map((String)result);
                log.info("======After convert map is[" + resData + "]========");
                if (!MpiUtil.validate((Map)resData, (String)encoding)) {
                    throw new UnionPayException(UnionPayRes.RTN000005);
                }
                return resData;
            }
            String message = "Connect to url[" + url + "] fail,response is null";
            throw new UnionPayException(UnionPayRes.RTN000004.getCode(), message);
        }
        String message = "Connect to url[" + url + "] fail,status is [" + status + "]";
        throw new UnionPayException(UnionPayRes.RTN000003.getCode(), message);
    }

    public static boolean isExpParam(String paramName) {
        int i = 0;
        while (i < EXPPARAM.length) {
            if (EXPPARAM[i].equals(paramName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Object mapToBean(Map<String, String> map, Class<?> clazz) throws Exception {
        Object obj = clazz.newInstance();
        for (String key : map.keySet()) {
            String value = map.get(key);
            Field field = clazz.getDeclaredField(key);
            if (field == null) continue;
            field.setAccessible(true);
            field.set(obj, value);
        }
        return obj;
    }
}

