/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.uniononlinepay.util;

import com.xunlei.uniononlinepay.constant.UnionPayProp;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FaceFileReader {
    private static final Logger LOG = LoggerFactory.getLogger(FaceFileReader.class);

    public static List<String> getMustParamsList(String fileName) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        SAXReader reader = new SAXReader();
        InputStream is = FaceFileReader.class.getClassLoader().getResourceAsStream("com/xunlei/uniononlinepay/xml/" + fileName);
        Document document = reader.read(is);
        List nodeList = document.selectNodes("//service/param");
        int i = 0;
        while (i < nodeList.size()) {
            Element param = (Element)nodeList.get(i);
            String name = param.element("name").getText();
            list.add(name);
            ++i;
        }
        return list;
    }

    public static Map<String, String> getMustParamMap(String fileName) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        SAXReader reader = new SAXReader();
        InputStream is = FaceFileReader.class.getClassLoader().getResourceAsStream("com/xunlei/uniononlinepay/xml/" + fileName);
        Document document = reader.read(is);
        List nodeList = document.selectNodes("//service/param");
        int i = 0;
        while (i < nodeList.size()) {
            Element param = (Element)nodeList.get(i);
            Element name = param.element("name");
            Element dvalue = param.element("dvalue");
            if (name != null) {
                if (dvalue == null || "".equals(dvalue)) {
                    map.put(name.getText(), null);
                } else {
                    map.put(name.getText(), dvalue.getText());
                }
            }
            ++i;
        }
        return map;
    }

    public static String getFaceURL(String fileName) throws Exception {
        SAXReader reader = new SAXReader();
        InputStream is = FaceFileReader.class.getClassLoader().getResourceAsStream("com/xunlei/uniononlinepay/xml/" + fileName);
        Document document = reader.read(is);
        Node node = document.selectSingleNode("//service");
        String urlTemp = node.valueOf("@url");
        String url = UnionPayProp.getProperties(urlTemp);
        LOG.info("urlTemp:{},url:{}", new Object[]{urlTemp, url});
        return url;
    }

    public static boolean getFaceAction(String fileName) throws Exception {
        SAXReader reader = new SAXReader();
        InputStream is = FaceFileReader.class.getClassLoader().getResourceAsStream("com/xunlei/uniononlinepay/xml/" + fileName);
        Document document = reader.read(is);
        Node node = document.selectSingleNode("//service");
        String reFlag = node.valueOf("@redirect");
        return "true".equals(reFlag);
    }
}

