/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.uniononlinepay.service;

import com.unionpay.mpi.MpiConfig;
import com.unionpay.mpi.MpiUtil;
import com.unionpay.mpi.SecureUtil;
import com.xunlei.uniononlinepay.constant.UnionPayRes;
import com.xunlei.uniononlinepay.dictonary.CustomerInfo;
import com.xunlei.uniononlinepay.dictonary.UnionDataDictonary;
import com.xunlei.uniononlinepay.exception.UnionPayException;
import com.xunlei.uniononlinepay.util.FaceFileReader;
import com.xunlei.uniononlinepay.util.UnionPayUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnionPayService {
    private static final Logger LOG = LoggerFactory.getLogger(UnionPayService.class);

    static {
        UnionPayService.init();
    }

    public static void init() {
        MpiConfig.getConfig().loadPropertiesFromSrc();
        LOG.info("UnionPayService init success!");
    }

    public static Map<String, String> redService(UnionDataDictonary data) throws Exception {
        UnionPayService.validate(data);
        LOG.info("orderid:{},begin redService,FaceFileName:{}", new Object[]{data.getOrderId(), data.getFaceFileName()});
        Map<String, String> hiddens = UnionPayUtil.getMapFromParams(data);
        String url = FaceFileReader.getFaceURL(data.getFaceFileName());
        hiddens.put("action", url);
        return hiddens;
    }

    public static Map<String, String> dirServiceRes(UnionDataDictonary data) throws Exception {
        UnionPayService.validate(data);
        LOG.info("orderid:{},begin dirServiceRes,FaceFileName:{}", new Object[]{data.getOrderId(), data.getFaceFileName()});
        String url = FaceFileReader.getFaceURL(data.getFaceFileName());
        Map<String, String> params = UnionPayUtil.getMapFromParams(data);
        Map<String, String> urlRes = UnionPayUtil.unionHttpPost(url, params, "UTF-8");
        return urlRes;
    }

    public static void validate(UnionDataDictonary data) throws Exception {
        String faceFileName = data.getFaceFileName();
        if (faceFileName == null || "".equals(faceFileName)) {
            LOG.error("===orderId:{},FaceFileName is empty!===", new Object[]{data.getOrderId()});
            throw new UnionPayException(UnionPayRes.RTN000001);
        }
    }

    public static String getCustomer(CustomerInfo customerInfo) {
        String encoding = "UTF-8";
        StringBuffer sf = new StringBuffer("{");
        String customerInfo01 = "";
        if (customerInfo.getCustomerInfo01() != null) {
            customerInfo01 = customerInfo.getCustomerInfo01();
        }
        String customerInfo02 = "";
        if (customerInfo.getCustomerInfo02() != null) {
            customerInfo02 = customerInfo.getCustomerInfo02();
        }
        String customerInfo03 = "";
        if (customerInfo.getCustomerInfo03() != null) {
            customerInfo03 = customerInfo.getCustomerInfo03();
        }
        String customerInfo04 = "";
        if (customerInfo.getCustomerInfo04() != null) {
            customerInfo04 = customerInfo.getCustomerInfo04();
        }
        String customerInfo05 = "";
        if (customerInfo.getCustomerInfo05() != null) {
            customerInfo05 = customerInfo.getCustomerInfo05();
        }
        String customerInfo06 = "";
        if (customerInfo.getCustomerInfo06() != null) {
            customerInfo06 = customerInfo.getCustomerInfo06();
        }
        String customerInfo07 = "";
        if (customerInfo.getCustomerInfo07() != null) {
            customerInfo07 = customerInfo.getCustomerInfo07();
        }
        String customerInfo08 = "";
        if (customerInfo.getCustomerInfo08() != null) {
            customerInfo08 = customerInfo.getCustomerInfo08();
        }
        sf.append(customerInfo01).append("|");
        sf.append(customerInfo02).append("|");
        sf.append(customerInfo03).append("|");
        sf.append(customerInfo04).append("|");
        sf.append(customerInfo05).append("|");
        sf.append(customerInfo06).append("|");
        sf.append(customerInfo07).append("|");
        sf.append(customerInfo08);
        sf.append("}");
        LOG.info("customerInfo is :{" + sf.toString() + "}");
        try {
            return new String(SecureUtil.base64Encode((byte[])sf.toString().getBytes(encoding)));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "";
    }

    public static boolean validateSign(Map<String, String> map) {
        LOG.info("validateSign invoking!map:{}", new Object[]{map});
        return MpiUtil.validate(map, (String)"UTF-8");
    }

    public static byte[] base64Decode(String info) throws Exception {
        byte[] bytes = SecureUtil.inflater((byte[])SecureUtil.base64Decode((byte[])info.getBytes("UTF-8")));
        return bytes;
    }

    public static void main(String[] args) {
        String str = "eJw0mHc81Y8X/++1bpmRcSura14urhHZhZtrZ29de49kZt2McAmX7CQzsq69ude+VkbJCOESkULFlfj5fH+/3//vx/tx3u9zzuv1fJ2HOpRUrAAA4AogRE9WI3T6DaY9FgD45woCcAHYAFr6+pIycEkpybt3rfQe3ZW/KyMDl5aTl5eGw+FypiZXAZTGkFUjV4FVI9MQKsAv4C/";
        String str2 = "\u6211\u64e6\u554a!";
        try {
            byte[] b1 = str2.getBytes();
            System.out.println(UnionPayService.base64Decode(str));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

