package com.xunlei.util.http;

import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

import java.io.IOException;

/**
 * @author xiongyingqi
 * @version 2016-03-14 16:29
 */
public abstract class HttpUtils {
    public static HttpClient newClient() {
        CloseableHttpClient client = HttpClientBuilder.create()
                .build();
        return client;
    }

    public static HttpResponse doGet(String uri, int timeout) throws IOException {
        HttpClient client = newClient();
        HttpGet get = new HttpGet(uri);

        RequestConfig config = createTimeOutConfig(timeout);
        get.setConfig(config);

        HttpResponse response = client.execute(get);
        return response;
    }

    public static HttpResponse doGet(String uri) throws IOException {
        return doGet(uri, 10000);
    }

    public static HttpResponse doPost(String uri, HttpEntity entity, int timeout)
            throws IOException {
        HttpClient client = newClient();
        HttpPost post = new HttpPost(uri);
        post.setEntity(entity);

        RequestConfig config = createTimeOutConfig(timeout);
        post.setConfig(config);

        HttpResponse response = client.execute(post);
        return response;
    }

    public static HttpResponse doPost(String uri, HttpEntity entity) throws IOException {
        return doPost(uri, entity, 10000);
    }

    public static HttpResponse doPut(String uri, HttpEntity entity, int timeout)
            throws IOException {
        HttpClient client = newClient();
        HttpPut put = new HttpPut(uri);
        put.setEntity(entity);

        RequestConfig config = createTimeOutConfig(timeout);
        put.setConfig(config);

        HttpResponse response = client.execute(put);
        return response;
    }

    public static HttpResponse doPut(String uri, HttpEntity entity) throws IOException {
        return doPut(uri, entity, 10000);
    }

    public static HttpResponse doDelete(String uri, int timeout)
            throws IOException {
        HttpClient client = newClient();
        HttpDelete delete = new HttpDelete(uri);

        RequestConfig config = createTimeOutConfig(timeout);
        delete.setConfig(config);

        HttpResponse response = client.execute(delete);
        return response;
    }

    public static HttpResponse doDelete(String uri) throws IOException {
        return doDelete(uri, 10000);
    }

    public static RequestConfig createTimeOutConfig(int timeout) {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(timeout)
                .setConnectionRequestTimeout(timeout).build();
        return config;
    }

    public static void main(String[] args) throws IOException {
        HttpResponse response = HttpUtils.doGet("http://www.taobao.com", 100);
        System.out.println(IOUtils.readLines(response.getEntity().getContent()));
        StringEntity stringEntity = new StringEntity("");
        HttpResponse response2 = HttpUtils.doPost("http://www.taobao.com", stringEntity);
        System.out.println(IOUtils.readLines(response2.getEntity().getContent()));

    }
}
