package com.xunlei.stream.vo;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

/**
 * @author xiongyingqi
 * @version 2016-03-14 17:17
 */
public class AccountInterfaceLockUsers extends AccountInterfaceLockData {
    private String action = "ip";
    private AccountInterfaceLockUser[] data;

    public AccountInterfaceLockUser[] getData() {
        return data;
    }

    public String getAction() {
        return action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setData(AccountInterfaceLockUser[] data) {
        this.data = data;
    }

    public static void main(String[] args) throws JsonProcessingException {
        AccountInterfaceLockUser accountInterfaceLockUser = new AccountInterfaceLockUser();
        accountInterfaceLockUser.setNip(1L);
        accountInterfaceLockUser.setUid(40L);
        accountInterfaceLockUser.setIps(new String[]{"192.168.2.1","192.168.3.1"});

        AccountInterfaceLockUser accountInterfaceLockUser2 = new AccountInterfaceLockUser();
        accountInterfaceLockUser2.setNip(20L);
        accountInterfaceLockUser2.setUid(2L);
        accountInterfaceLockUser2.setIps(new String[]{"192.168.4.2","192.168.3.1"});


        AccountInterfaceLockUsers accountInterfaceLockUsers = new AccountInterfaceLockUsers();
        AccountInterfaceLockUser[] accountInterfaceLockUserArr = new AccountInterfaceLockUser[] {
                accountInterfaceLockUser, accountInterfaceLockUser2 };
        accountInterfaceLockUsers.setData(accountInterfaceLockUserArr);

        ObjectMapper mapper = new ObjectMapper();
        String json = mapper.writeValueAsString(accountInterfaceLockUsers);
        System.out.println(json);
    }
}
