package com.xunlei.stream.vo;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;

import java.io.IOException;

/**
 * @author xiongyingqi
 * @version 2016-03-14 17:28
 */
public class AccountInterfaceConfigResult extends AccountInterfaceResult{
    private AccountInterfaceConfigResultData ip ;
    @JsonProperty("peerid")
    private AccountInterfaceConfigResultData peerId;
    @JsonProperty("deviceid")
    private AccountInterfaceConfigResultData deviceId;

    public AccountInterfaceConfigResultData getIp() {
        return ip;
    }

    public void setIp(AccountInterfaceConfigResultData ip) {
        this.ip = ip;
    }

    public AccountInterfaceConfigResultData getPeerId() {
        return peerId;
    }

    public void setPeerId(AccountInterfaceConfigResultData peerId) {
        this.peerId = peerId;
    }

    public AccountInterfaceConfigResultData getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(AccountInterfaceConfigResultData deviceId) {
        this.deviceId = deviceId;
    }

    @Override
    public String toString() {
        return "AccountInterfaceConfigResult{" +
                "ip=" + ip +
                ", peerId=" + peerId +
                ", deviceId=" + deviceId +
                "} " + super.toString();
    }

    public static void main(String[] args) throws IOException {
        String json2 = "{\"result\":200,\"ip\":{\"interval\":[10,20,30]},\"message\":\"success\",\"peerid\":{\"interval\":[10,20,30]},\"deviceid\":{\"interval\":[10,20,30]}}";
        System.out.println(json2);
        ObjectMapper mapper = new ObjectMapper();
        AccountInterfaceConfigResult accountInterfaceConfigResult = mapper
                .readValue(json2, AccountInterfaceConfigResult.class);
        System.out.println(accountInterfaceConfigResult);
    }
}
