package com.xunlei.stream.util.redis.impl;

import com.xunlei.stream.util.PropertiesUtil;
import com.xunlei.stream.util.redis.RedisApi;
import com.xunlei.stream.util.redis.RedisProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Arrays;

/**
 * 默认提供方式
 *
 * @author <a href="http://xiongyingqi.com">qi</a>
 * @version 2015-10-22 17:21
 */
public class RedisClientProvider implements RedisProvider {
    private static final Logger logger = LoggerFactory.getLogger(RedisClientProvider.class);
    private String[] redisNodes;
    private boolean  redisNeedAuth;
    private String   redisPassword;
    private int      redisPort;
    private Redis    redis;

    public RedisClientProvider() {
        try {
            PropertiesUtil propertiesUtil = new PropertiesUtil("baseCfg.properties");
            String redisNodes = propertiesUtil.getProperty("redis.nodes");
            String redisNeedAuth = propertiesUtil.getProperty("redis.needauth");
            String redisPassword = propertiesUtil.getProperty("redis.password");
            String redisPort = propertiesUtil.getProperty("redis.port");
            this.redisNodes = redisNodes.split(",");
            this.redisNeedAuth = Boolean.parseBoolean(redisNeedAuth);
            this.redisPort = Integer.parseInt(redisPort);
            this.redisPassword = redisPassword;
            initRedis();
            logger.info(
                    "RedisClientProvider... redisNodes: {}, redisNeedAuth: {}, redisPassword: {}, redisPort: {}",
                    Arrays.toString(this.redisNodes), redisNeedAuth, redisPassword, redisPort);
        } catch (Exception e) {
            logger.error("init config error with message: " + e.getMessage(), e);
        }

    }

    private void initRedis() {
        if (redisNeedAuth) {
            redis = new Redis(redisNodes[0], redisPort, redisPassword);
        } else {
            redis = new Redis(redisNodes[0], redisPort);
        }
    }

    @Override
    public RedisApi newRedisClient(String instanceName) {
        try {
            RedisApi redisApi = innerNewRedisClient(instanceName);
            logger.debug("newRedisClient... return instance: {}", redisApi);
            return redisApi;
        } catch (Exception e) {
            logger.error(
                    "Caught exception when creating a redis client, message: " + e.getMessage(), e);
            return null;
        }
    }

    private RedisApi innerNewRedisClient(String instanceName) {
        return redis;
    }
}
