package com.xunlei.stream.util.redis;

import redis.clients.jedis.Jedis;
import redis.clients.jedis.Tuple;

import java.util.Map;
import java.util.Set;

/**
 * redis操作接口
 *
 * @author <a href="http://xiongyingqi.com">qi</a>
 * @version 2015-10-22 17:06
 */
public interface RedisApi {
    Jedis getJedis();

    void closeJedis(Jedis jedis);

    /**
     * 回收资源
     */
    void returnResource();

    String get(String key);

    Map<String, String> hGetAll(String key);

    String hGet(String key, String field);

    void hSet(String key, String subKey, String value);

    void hDel(String key, String subKey);

    void hDel(String key, String[] subKey);

    Long sAdd(String key, String value);

    void zAdd(String key, String member, Integer value);
    /**
     * @param key
     * @param value
     * @param holdTime 秒为单位
     */
    void set(String key, String value, int holdTime);

    /**
     * 有序集添加操作
     *
     * @param key   键
     * @param value 值
     * @param score 得分
     */
    void zadd(String key, double score, String value);

    /**
     * 获取有序集
     *
     * @param key   键
     * @param start 开始行
     * @param end   结束行
     */
    Set<String> zrange(String key, long start, long end);

    /**
     * 获取有序集（带分数）
     *
     * @param key   键
     * @param start 开始行
     * @param end   结束行
     * @return
     */
    Set<Tuple> zrangeWithScores(String key, long start, long end);

    /**
     * 根据score返回获取有序集
     *
     * @param key 键
     * @param min 最小分数
     * @param max 最大分数
     */
    Set<String> zrangeByScore(String key, double min, double max);

    /**
     * 根据score返回获取有序集
     *
     * @param key 键
     * @param min 最小分数
     * @param max 最大分数
     */
    Set<Tuple> zrangeByScoreAndResultWithScores(String key, double min, double max);

    /**
     * 根据score返回获取有序集（倒序）
     *
     * @param key 键
     * @param min 最小分数
     * @param max 最大分数
     */
    Set<String> zrevrangeByScore(String key, double max, double min);

    /**
     * 根据score返回获取有序集（带limit、倒序）
     *
     * @param key    键
     * @param min    最小分数
     * @param max    最大分数
     * @param offset 偏移量
     * @param limit  最大结果集
     */
    Set<String> zrevrangeByScore(String key, double max, double min, int offset, int limit);

    /**
     * 根据score返回获取有序集（倒序，带分数）
     *
     * @param key 键
     * @param min 最小分数
     * @param max 最大分数
     */
    Set<Tuple> zrevrangeByScoreAndResultWithScores(String key, double max, double min);

    /**
     * 根据score返回获取有序集（倒序）
     *
     * @param key   键
     * @param start 开始行
     * @param end   结束行
     */
    Set<String> zrevrange(String key, long start, long end);

    /**
     * 根据score返回获取有序集（倒序）
     *
     * @param key   键
     * @param start 开始行
     * @param end   结束行
     */
    Set<Tuple> zrevrangeWithScores(String key, long start, long end);
}
