package com.xunlei.stream.util.ip;

/**
 * ip地址信息
 * @author <a href="http://xiongyingqi.com">qi</a>
 * @version 2015-10-20 14:33
 */
public class IpAreaInfo {
    private String province;
    private String city;
    private Long   start;
    private Long   end;
    private int    key;

    public IpAreaInfo(String province, String city, Long start, Long end, int key) {
        this.province = province;
        this.city = city;
        this.start = start;
        this.end = end;
        this.key = key;
    }

    public IpAreaInfo() {
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public Long getStart() {
        return start;
    }

    public void setStart(Long start) {
        this.start = start;
    }

    public Long getEnd() {
        return end;
    }

    public void setEnd(Long end) {
        this.end = end;
    }

    public int getKey() {
        return key;
    }

    public void setKey(int key) {
        this.key = key;
    }

    @Override
    public String toString() {
        return "IpAreaInfo{" +
                "province='" + province + '\'' +
                ", city='" + city + '\'' +
                ", start=" + start +
                ", end=" + end +
                ", key=" + key +
                '}';
    }

    @Override
    public boolean equals(Object o) {

        if (this == o)
            return true;
        if (!(o instanceof IpAreaInfo))
            return false;

        IpAreaInfo that = (IpAreaInfo) o;

        if (key != that.key)
            return false;
        if (province != null ? !province.equals(that.province) : that.province != null)
            return false;
        if (city != null ? !city.equals(that.city) : that.city != null)
            return false;
        if (start != null ? !start.equals(that.start) : that.start != null)
            return false;
        if (end != null ? !end.equals(that.end) : that.end != null)
            return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = province != null ? province.hashCode() : 0;
        result = 31 * result + (city != null ? city.hashCode() : 0);
        result = 31 * result + (start != null ? start.hashCode() : 0);
        result = 31 * result + (end != null ? end.hashCode() : 0);
        result = 31 * result + key;
        return result;
    }
}
