package com.xunlei.stream.util.ip;

import com.xunlei.stream.factory.Factory;
import com.xunlei.stream.util.ip.mysql.MySQLIpAreaProvider;
import com.xunlei.common.ClassHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ResourceBundle;

/**
 * @author <a href="http://xiongyingqi.com">qi</a>
 * @version 2015-11-02 20:47
 */
public abstract class IpAreaFactory implements Factory {
    private static final Logger logger = LoggerFactory.getLogger(IpAreaFactory.class);
    private static IpAreaProvider ipAreaProvider;
    private static final IpAreaProvider DEFAULT_PROVIDER = new MySQLIpAreaProvider();

    static {
        initProvider();
    }

    @SuppressWarnings("unchecked")
    public static void initProvider() {
        ResourceBundle bundle = ResourceBundle.getBundle(PROFILE_BUNDLE_NAME);
        String providerClassStr = bundle.getString("IpAreaFactory.provider");
        try {
            Class<?> providerClass = Class.forName(providerClassStr);
            boolean implementsInterface = ClassHelper
                    .isImplementsInterface(providerClass, IpAreaProvider.class);
            logger.info("init profile: {}, provider class: {}, implements IpAreaProvider: {}",
                    PROFILE_BUNDLE_NAME, providerClass, implementsInterface);
            if (!implementsInterface) {
                return;
            }
            Class<IpAreaProvider> cast = (Class<IpAreaProvider>) providerClass;
            IpAreaProvider ipAreaProvider = cast.newInstance();
            setIpAreaProvider(ipAreaProvider);
        } catch (ClassNotFoundException e) {
            logger.error("load profile: " + PROFILE_BUNDLE_NAME + " and class: " + providerClassStr
                    + " not found! with exception: " + e.getMessage(), e);
        } catch (InstantiationException e) {
            logger.error("class: " + providerClassStr
                    + " instantiation error with message: " + e.getMessage(), e);
        } catch (IllegalAccessException e) {
            logger.error("load profile: " + PROFILE_BUNDLE_NAME + " and class: " + providerClassStr
                    + " caught IllegalAccessException! message: " + e.getMessage(), e);
        }
    }

    /**
     * 由于spark分布式的特性，决定了driver内设置的provider不能使各个executor内的设置生效，为了保证每个executor都能实例化provider，我们使用静态初始化
     *
     * @param ipAreaProvider
     */
    public static void setIpAreaProvider(IpAreaProvider ipAreaProvider) {
        if (IpAreaFactory.ipAreaProvider != null) {
            logger.warn("setIpAreaProvider... reset provider: old provider = {}, new provider = {}",
                    IpAreaFactory.ipAreaProvider, ipAreaProvider);
        } else {
            logger.info("setIpAreaProvider... set provider: {}", ipAreaProvider);
        }
        IpAreaFactory.ipAreaProvider = ipAreaProvider;
    }

    public static IpAreaApi newApi() throws IllegalIpAreaProviderException {
        if (ipAreaProvider == null) {
            ipAreaProvider = DEFAULT_PROVIDER;
            //            throw new IllegalIpAreaProviderException("please set the ipAreaProvider first!");
        }
        return ipAreaProvider.newIpAreaApi();
    }

    public static int ipToAreaId(String ip) throws IllegalIpAreaProviderException {
        IpAreaApi ipAreaApi = newApi();
        if (ipAreaApi == null) {
            throw new IllegalIpAreaProviderException("ipAreaProvider products a null ipAreaApi!");
        }
        return ipAreaApi.ipToAreaId(ip);
    }

    public static IpAreaInfo getIpInfo(String ip) throws IllegalIpAreaProviderException {
        IpAreaApi ipAreaApi = newApi();
        if (ipAreaApi == null) {
            throw new IllegalIpAreaProviderException("ipAreaProvider products a null ipAreaApi!");
        }
        IpAreaInfo ipInfo = ipAreaApi.getIpInfo(ip);
        return ipInfo;
    }

    public static void main(String[] args) throws IllegalIpAreaProviderException {
        boolean implementsInterface = ClassHelper
                .isImplementsInterface(MySQLIpAreaProvider.class, IpAreaProvider.class);
        System.out.println(implementsInterface);
        //        new IpAreaFactory(){};
        IpAreaFactory.newApi();
        IpAreaFactory.newApi();

    }

}
