package com.xunlei.stream.util.http;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xunlei.stream.vo.AccountInterfaceConfigResult;
import com.xunlei.stream.vo.AccountInterfaceLockData;
import com.xunlei.stream.vo.AccountInterfaceResult;
import com.xunlei.util.http.HttpUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.io.InputStream;
import java.util.ResourceBundle;

/**
 * @author xiongyingqi
 * @version 2016-03-14 16:04
 */
public abstract class AccountInterfaceUtil {
    private static final Logger logger = LoggerFactory.getLogger(AccountInterfaceUtil.class);
    private static String getConfURL;
    private static String lockUserURL;
    public static final ThreadLocal<ObjectMapper> MAPPER = new ThreadLocal<ObjectMapper>() {
        @Override
        protected ObjectMapper initialValue() {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return objectMapper;
        }
    };

    static {
        init();
    }

    private static void init() {
        ResourceBundle baseCfg = ResourceBundle.getBundle("baseCfg");
        getConfURL = baseCfg.getString("account.interface.getConf");
        lockUserURL = baseCfg.getString("account.interface.lockUser");
    }

    /**
     * 获取策略配置
     *
     * @return {@link AccountInterfaceConfigResult}
     * @throws IOException
     */
    public static AccountInterfaceConfigResult getConf() throws IOException {
        HttpResponse response =
                HttpUtils.doGet(getConfURL, 10000);// 10s等待时间
        HttpEntity entity = response.getEntity();
        InputStream content = entity.getContent();
        AccountInterfaceConfigResult accountInterfaceConfigResult = MAPPER.get()
                .readValue(content, AccountInterfaceConfigResult.class);
        return accountInterfaceConfigResult;
    }

    /**
     * post锁定数据
     *
     * @param lockData {@link AccountInterfaceLockData}
     * @return {@link AccountInterfaceResult}
     * @throws IOException
     */
    public static AccountInterfaceResult postResult(AccountInterfaceLockData lockData)
            throws IOException {
        String json = parseObjectToJacksonString(lockData);
        HttpEntity entity = new StringEntity(json, ContentType.APPLICATION_JSON);
        HttpResponse response = HttpUtils.doPost(lockUserURL, entity, 10000);
        HttpEntity responseEntity = response.getEntity();
        InputStream content = responseEntity.getContent();
        try {

            AccountInterfaceResult accountInterfaceResult = parseObject(content,
                    AccountInterfaceResult.class);
            return accountInterfaceResult;
        } catch (Exception e) {
            logger.error("Post result error! data: " + lockData
                    + " error message: " + e.getMessage(), e);
            return null;
        }
    }

    private static <T> T parseObject(InputStream inputStream, Class<T> clazz) throws IOException {
        T t = MAPPER.get().readValue(inputStream, clazz);
        return t;
    }
    private static <T> T parseObject(String json, Class<T> clazz) throws IOException {
        T t = MAPPER.get().readValue(json, clazz);
        return t;
    }

    private static String parseObjectToJacksonString(
            Object object) throws IOException {
        String json = MAPPER.get().writeValueAsString(object);
        return json;
    }

    public static void main(String[] args) throws IOException {
//        Map<String, String> map = new HashMap<String, String>();
//        map.put("1", "a");
//        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
//        try {
//            MAPPER.get().writeValue(outputStream, map);
//            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(
//                    outputStream.toByteArray());
//            Map map1 = MAPPER.get().readValue(byteArrayInputStream, Map.class);
//            System.out.println(map1);
//        } catch (IOException e) {
//            e.printStackTrace();
//        }

        System.out.println(getConf());
    }
}
