package com.xunlei.stream.util;

/**
 * @author xiongyingqi
 * @version 2016-01-04 11:16
 */
public abstract class TimerHelper {

    /**
     * <pre>
     * Timer timer = TimerHelper.newTimer();
     * try {
     *      Thread.sleep(1000);
     * } catch (InterruptedException e) {
     *      e.printStackTrace();
     * }
     * Long end = timer.end();
     * System.out.println(end);
     * </pre>
     *
     * @return
     */
    public static Timer newTimer() {
        return new Timer();
    }

    public static class Timer {
        private long startTime;
        private long endTime;

        public Timer() {
            this(System.currentTimeMillis());
        }

        public Timer(Long startTime) {
            this.startTime = startTime;
        }

        /**
         * 重置
         */
        public void reset() {
            startTime = System.currentTimeMillis();
            endTime = 0L;
        }


        /**
         * 计算间隔时间
         *
         * @return
         */
        public Long interval() {
            if (endTime == 0L) {
                endTime = System.currentTimeMillis();
            }
            return endTime - startTime;
        }

        public Long getStartTime() {
            return startTime;
        }

        public void setStartTime(Long startTime) {
            this.startTime = startTime;
        }

        public Long getEndTime() {
            return endTime;
        }

        public void setEndTime(Long endTime) {
            this.endTime = endTime;
        }
    }

}

