package com.xunlei.stream.util;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.ws.rs.core.MediaType;

/**
 * Created by yunwang on 2015/11/20.
 */
public class RestfulUtil {
    private static final Logger log = LoggerFactory.getLogger(RestfulUtil.class);

    //    private static final String url = "http://vip23:8080/rest/log/stream";
//    private static String url = "http://tw07303.sandai.net:9600/rest/log/stream";
//
//    public static void post(String param) {
//        post(url, param);
//    }

    public static String post(String url, String param) {
        Client client = null;
        WebResource resource = null;
        String res = "";
        try {

            client = Client.create();
            resource = client.resource(url);
            res = resource.type(MediaType.APPLICATION_JSON).post(String.class, param);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        } finally {
            try {

                if (client != null)
                    client.destroy();
            } catch (Exception e) {
                log.warn(e.getMessage(), e);
            }
        }

        return res;

    }

    public static String get(String url) {
        Client client = null;
        WebResource resource = null;
        String res = "";
        try {

            client = Client.create();
            resource = client.resource(url);
            res = resource.type(MediaType.APPLICATION_JSON).get(String.class);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        } finally {
            try {

                if (client != null)
                    client.destroy();
            } catch (Exception e) {
                log.warn(e.getMessage(), e);
            }

        }

        return res;

    }

}
