package com.xunlei.stream.util

/**
  * @author xiongyingqi
  * @version 2016-02-04 10:28
  */
object KafkaBrokerUtils {
  def kafkaConsumersToProducerBrokers(zkQuorum: String): String = {
    val rs = zkQuorum
      .split(",")
      .map(
        x => {
          val portIndex = x.indexOf(":")
          x.substring(0, portIndex)
        })
      .foldLeft(new StringBuilder())((x: StringBuilder, y: String) => {
        x.append(y).append(":9092,")
      })

    rs.substring(0, rs.length - 1)
  }


  def main(args: Array[String]) {
    val kafkaBrokers = kafkaConsumersToProducerBrokers("127.0.0.1:2181, 192.168.2.1:9092")
    println(s"kafkaBrokers=$kafkaBrokers")
  }

}
