package com.xunlei.stream.util;

import com.xunlei.common.Assert;

/**
 * @author <a href="http://xiongyingqi.com">qi</a>
 * @version 2015-08-17 15:56
 */
public abstract class IpUtil {
    //    public static final long MAX_IP = (((1 << 8) << 8 + 1 << 8) << 8 + 1 << 8) << 8 + 1 << 8;
    public static long MAX_IP;

    static {
        long sum = 0;

        for (int i = 0; i < 4; i++) {
            long n = (1 << 8) - 1;
            sum = (sum << 8) + n;
        }

        MAX_IP = sum;
    }

    /**
     * 将ip地址从左到右 按 rs = (rs << 8) + i 进行计算<p></p>
     * i为根据ip值按","分隔得出的数字。如 192.168.2.1 得到的i值分别为：192、168、2、1
     *
     * @param ip
     * @return
     * @throws Exception
     */
    public static long parseToLong(String ip) throws Exception {
        return parseSectionAndSubSection(ip, 4);
    }

    /**
     * long转换为ip地址
     * @param ipLong
     * @return
     * @throws Exception
     */
    public static String parseLongToIp(long ipLong) throws Exception {
        Assert.isTrue(ipLong <= MAX_IP, "ip number must not greater than: " + MAX_IP);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 4; i++) {
            long section = (ipLong >> (8 * (3 - i))) & 0xFF;
            builder.append(section);
            if (i < 3) {
                builder.append(".");
            }
        }
        return builder.toString();
    }

    /**
     * 截取前sectionSize位ip后（后面设置为0）进行转换，如
     * <pre>
     *     parseSectionAndSubSection("255.255.255.255", 2) // "255.255.255.255"=4294967295
     * </pre>
     * 则返回 "255.255.0.0" 的转换结果 4294901760
     * <br>
     * <b>注意：经过截取之后的值肯定是不大于截取之前的值的，即： parseSectionAndSubSection(ip, 0)>=parseSectionAndSubSection(ip, 1)>=parseSectionAndSubSection(ip, 2)>=parseSectionAndSubSection(ip, 3)>=parseSectionAndSubSection(ip, 4)</b>
     *
     * @param ip
     * @param subSectionSize
     * @return
     * @throws Exception
     */
    public static long parseSectionAndSubSection(String ip, int subSectionSize) throws Exception {
        Assert.hasLength(ip, "ip must no be null!");
        Assert.isTrue(subSectionSize <= 4, "subSectionSize couldn't greater than 4!");
        String[] sections = ip.trim().split("\\.");
        Assert.notEmpty(sections, "illegal ip format!");
        Assert.equals(sections.length, 4, "illegal ip format!");
        long rs = 0;
        for (int i = 0; i < subSectionSize; i++) {
            long n = Integer.parseInt(sections[i]);
            rs = (rs << 8) + n;
        }
        for (int i = subSectionSize; i < 4; i++) {
            long n = 0;
            rs = (rs << 8) + n;
        }
        return rs;
    }

    public static void main(String[] args) throws Exception {
        System.out.println(2 << 8);
        String ip1 = "1.0.1.0";
        String ip2 = "223.255.252.0";
        String ip3 = "74.125.45.100";
        String ip4 = "74.125.45.0";
        String ip5 = "221.11.127.255";
        String ip6 = "255.255.255.255";
        System.out.println(parseToLong(ip1) == 16777472);
        System.out.println(parseToLong(ip2) == 3758095360L);
        System.out.println(parseToLong(ip3));
        System.out.println(parseToLong(ip4));
        System.out.println("221.11.127.255====" + parseToLong(ip5));
        System.out.println("221.11.127.255 section====" + parseSectionAndSubSection(ip5, 2));
        System.out.println("MAX_IP====" + MAX_IP);
        System.out.println(ip6 + "====" + parseToLong(ip6));
        System.out.println(ip6 + " section====" + parseSectionAndSubSection(ip6, 0));
        System.out.println(ip6 + " section====" + parseSectionAndSubSection(ip6, 1));
        System.out.println(ip6 + " section====" + parseSectionAndSubSection(ip6, 2));
        System.out.println(ip6 + " section====" + parseSectionAndSubSection(ip6, 3));
        System.out.println(ip6 + " section====" + parseSectionAndSubSection(ip6, 4));
    }
}
