package com.xunlei.stream.util

import org.slf4j.LoggerFactory

/**
  * @author xiongyingqi
  * @version 2016-04-06 11:18
  */
trait InfluxDbCommon {
  val logger = LoggerFactory.getLogger(classOf[InfluxDbCommon])
  protected val callbackService: CallbackExecutorCompletionService[Boolean] = CallbackExecutorCompletionService(20)
  callbackService.startReceive(fluxDbCallbackResult)

  def fluxDbCallbackResult(result: Boolean): Unit = {
    if (!result){
      logger.error("A flux db record send failed!")
    }
  }


}
