package com.xunlei.stream.util

import java.util.concurrent._

/**
  * @author xiongyingqi
  * @version 2016-03-14 13:48
  */
object CallbackExecutorCompletionService {
  val DEFAULT_POOL_SIZE = 20

  def apply[V](): CallbackExecutorCompletionService[V] = {
    val service: CallbackExecutorCompletionService[V] = new CallbackExecutorCompletionService(DEFAULT_POOL_SIZE)
    println(s"init thread pool: $service")
    service
  }

  def apply[V](poolSize: Int): CallbackExecutorCompletionService[V] = {
    val service: CallbackExecutorCompletionService[V] = new CallbackExecutorCompletionService(poolSize)
    println(s"init thread pool: $service")
    service
  }

}

class CallbackExecutorCompletionService[V](poolSize: Int) {
  private val queue: BlockingQueue[Runnable] = new LinkedBlockingQueue[Runnable]
  private val threadPool: ExecutorService = new ThreadPoolExecutor(poolSize, poolSize, 0L, TimeUnit.SECONDS, queue)
  private val cs: CompletionService[V] = new ExecutorCompletionService[V](threadPool)

//  /**
//    * 提交任务
//    *
//    * @param callable 调用的任务
//    * @param callback 任务执行完成时回调函数
//    * @param timeout  超时数值
//    * @param timeUnit 超时数值单位
//    */
//  def submit(callable: Callable[V], callback: (V) => Unit, timeout: Long, timeUnit: TimeUnit): Unit = {
//    val future: Future[V] = cs.submit(callable)
//    val v: V = future.get(timeout, timeUnit)
//    callback(v)
//  }
//
//  /**
//    * 提交任务
//    *
//    * @param callFunc 任务调用时所调用的函数
//    * @param callback 任务执行完成时回调该函数
//    * @param timeout  超时数值
//    * @param timeUnit 超时数值单位
//    */
//  def submit(callFunc: () => V, callback: (V) => Unit, timeout: Long, timeUnit: TimeUnit): Unit = {
//    val future: Future[V] = cs.submit(new Callable[V] {
//      override def call(): V = {
//        callFunc()
//      }
//    })
//    val v: V = future.get(timeout, timeUnit)
//    callback(v)
//  }

  /**
    * 提交任务
    *
    * @param callable Callable
    */
  def submit(callable: Callable[V]): Unit = {
    cs.submit(callable)
  }

  /**
    * 提交执行任务，注意，如果执行超时会抛异常
    *
    * @param callFunc 执行任务时调用的函数
    */
  def submit(callFunc: () => V): Unit = {
    cs.submit(new Callable[V] {
      override def call(): V = {
        callFunc()
      }
    })
  }

  /**
    * 开始接收返回值线程
    *
    * @param callbackFunc 任务执行完成时回调该函数
    */
  def startReceive(callbackFunc: (V) => Unit): Unit = {
    if (receiveThread != null && receiveThread.isAlive) {
      println("receiveThread is still alive!")
      return
    }
    println("create receiveThread...")
    createReceiveThread(callbackFunc)
    receiveThread.start()
  }

  var receiveThread: Thread = null

  def createReceiveThread(callbackFunc: (V) => Unit): Unit = {
    receiveThread = new Thread(new Runnable {
      override def run(): Unit = {
        while (true) {
          try {
            val poll: Future[V] = cs.take()
            val v: V = poll.get()
            callbackFunc(v)
          } catch {
            case e: Exception => e.printStackTrace()
          }
        }
      }
    })
  }

}
