package com.xunlei.common

import com.fasterxml.jackson.databind.{DeserializationFeature, ObjectMapper}

/**
  * Created by qi on 16-8-10.
  */
package object json {
  implicit def jsonFunctions[T](t: T): JsonFunctions[T] = new JsonFunctions(t)

  class JsonFunctions[T](t: T) {
    def toJson(): String = {
      toJson(getMapper())
    }

    def toJson(mapper: ObjectMapper): String = {
      try {
        mapper.writeValueAsString(t)
      } catch {
        case e: Exception =>
          println(e.getMessage)
          null
      }
    }

    private def getMapper(): ObjectMapper = {
      new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)
    }
  }

}
