package com.xunlei.common

import java.text.{DateFormat, SimpleDateFormat}
import java.util.{Calendar, Date}

/**
  * date utils
  * Created by qi on 16-8-9.
  */
package object date {
  val SHORT_DATE_FORMAT = "yyyy-MM-dd"
  val LONG_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss"

  def shortDateFormat = new SimpleDateFormat(SHORT_DATE_FORMAT)

  def longDateFormat = new SimpleDateFormat(LONG_DATE_FORMAT)

  // simple implicit

  implicit def longStringToDate(dateString: String): Date = longDateFormat.parse(dateString)


  //implicit class functions
  implicit def dateFunctions(date: Date): DateFunctions = new DateFunctions(date)

  class DateFunctions(date: Date) {

    def nextDate(): Date = {
      val after: Date = date.daysAfter(1)
      after
    }

    def toLongString(): String = {
      toString(longDateFormat)
    }

    def toShortString(): String = {
      toString(shortDateFormat)
    }

    def toString(formatString: String): String = {
      val format: SimpleDateFormat = new SimpleDateFormat(formatString)
      toString(format)
    }

    def toString(format: DateFormat): String = {
      format.format(date)
    }

    def --::(): String = toLongString()

    def --(): String = toShortString()
  }


  implicit def dateStringFunctions(dateString: String): StringDateFunctions = new StringDateFunctions(dateString)

  class StringDateFunctions(dateString: String) {

    def dateShortToLong(): String = {
      val date: Date = shortDateFormat.parse(dateString)
      val longDate: String = DateHelper.dateToStr(date, LONG_DATE_FORMAT)
      longDate
    }

    def dateLongToShort(): String = {
      val date: Date = longDateFormat.parse(dateString)
      val shortDate: String = DateHelper.dateToStr(date, SHORT_DATE_FORMAT)
      shortDate
    }

    def nextDate(): String = {
      val date: Date = longStringToDate(dateString)
      val after: Date = date.daysAfter(1)
      longDateFormat.format(after)
    }

    def parse(dateFormat: String): Date = {
      new SimpleDateFormat(dateFormat).parse(dateString)
    }

    def --::(): String = dateShortToLong()

    def --(): String = dateLongToShort()
  }


  implicit def shortToString(short: Short): String = short.toString


  implicit def calendarFunctions(date: Date): CalendarFunctions = new CalendarFunctions(date)

  class CalendarFunctions(date: Date) {
    def daysAfter(days: Int): Date = {
      val calendar: Calendar = Calendar.getInstance()
      calendar.setTime(date)
      calendar.add(Calendar.DATE, days)
      calendar.getTime
    }

    def dayOfWeek(): Int ={
      val calendar: Calendar = Calendar.getInstance()
      calendar.setTime(date)
      calendar.get(Calendar.DAY_OF_WEEK)
    }
  }

}
