package com.xunlei.common


/**
  * 反射工具
  *
  * @author <a href="http://xiongyingqi.com">qi</a>
  * @version 2015-10-21 21:01
  */
object ReflectionUtil {
  val SINGLETON_END_NAME = "$"
  val SINGLETON_FIELD_NAME = "MODULE$"

  /**
    * 根据class获取单例对象（必须是object关键字）
    *
    * @param clazz Class
    * @tparam T 泛型
    * @return T
    * @see http://blog.csdn.net/zhangjg_blog/article/details/23376465
    */
  def getSingleton[T](clazz: Class[T]): Option[T] = {
    if (!clazz.getSimpleName.endsWith(SINGLETON_END_NAME)) {
      println(s"class: $clazz not end with: '$SINGLETON_END_NAME', it's not a singleton object!" +
        "Must declared with 'object'. e.g., object A {}")
      return None
    }

    val field = clazz.getDeclaredField(SINGLETON_FIELD_NAME)
    if (field == null) {
      return None
    }
    val fieldType = field.getType
    if (!fieldType.equals(clazz)) {
      println("fieldType: " + fieldType + " not equals " + clazz)
      return None
    }
    val module: T = field.get(null).asInstanceOf[T]
    Some(module)
  }

  /**
    * test
    *
    * @param args
    */
  def main(args: Array[String]) {
    val o = getSingleton(ReflectionUtil.getClass)
    println(s"ReflectionUtil getSingleton(ReflectionUtil.getClass) =========== ${o.get}")
    println(s"ReflectionUtil =========== $ReflectionUtil")
    assert(getSingleton(ReflectionUtil.getClass).get == ReflectionUtil)
  }
}
