package com.xunlei.common;

import com.fasterxml.jackson.databind.ObjectMapper;

import java.io.*;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="http://xiongyingqi.com">qi</a>
 * @version 2015-07-29 17:49
 */
public class ReadFile {
    private String      filePath;
    private File        file;
    private InputStream inputStream;

    public void start() throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String line;
        line = bufferedReader.readLine();
        String[] headers = parse(line);

        File file = new File("result.json.tmp");
        OutputStream out = new FileOutputStream(file);
        PrintWriter print = new PrintWriter(out);

        ObjectMapper mapper = new ObjectMapper();

        while ((line = bufferedReader.readLine()) != null) {
//            EntityHelper.print(line);
            String[] words = parse(line);
            Map<String, String> map = new HashMap<String, String>();
            if(headers.length > words.length){
//                EntityHelper.print(headers.length);
//                EntityHelper.print(words.length);
//                EntityHelper.print(words);
                for (int i = 0; i < words.length; i++) {
                    map.put(headers[i], words[i]);
                }
                for (int i = 0; i < headers.length - words.length; i++) {
                    map.put(headers[words.length + i], "");
                }
                print.println(mapper.writeValueAsString(map));
//                System.out.println(line);
//                return;
            } else {
                for (int i = 0; i < words.length; i++) {
                    map.put(headers[i], words[i]);
                }
                print.println(mapper.writeValueAsString(map));
//                System.out.println("bingo!");
//                System.out.println(line);
//                EntityHelper.print(words);
//                System.out.println(words.length);

            }
        }
        out.flush();
        out.close();
        System.out.println(file.getCanonicalPath());
    }



    public String[] parse(String line){
        List<String> headerList = new ArrayList<String>();
        String[] split = line.split("\\t");
//        StringTokenizer tokenizer = new StringTokenizer(line, "\\t");
        for (String s : split) {
//            s = s.trim();
//            if (!StringHelper.nullOrEmpty(s)) {
                headerList.add(s);
//            }
        }
        String[] headers = headerList.toArray(new String[headerList.size()]);
        return headers;
    }


    public String getFilePath() {
        return filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
        File file = new File(filePath);
        if (!file.exists()) {
            System.err.println("filePath: [" + filePath +"], not exists");
            return;
        }
        setFile(file);
    }

    public File getFile() {
        return file;
    }

    public void setFile(File file) {
        this.file = file;
        if (!file.exists()) {
            System.err.println("file: [" + file +"], not exists");
            return;
        }
        InputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        setInputStream(inputStream);
    }

    public InputStream getInputStream() {
        return inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

}
