package com.xunlei.common;


import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;

import java.io.IOException;

/**
 * Created by yunwang on 2015/12/10.
 */
public class JsonUtil {

    public static ObjectMapper mapper = new ObjectMapper();

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }


    public static ObjectNode str2ObjectNode(String str) throws IOException {
        return mapper.readValue(str, ObjectNode.class);
    }

    public static void main(String[] args) throws IOException {
        String json = "{\"k\":\"v\"}";

        System.out.println(str2ObjectNode(json));

    }

}
