/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.pay;

import com.xunlei.pay.ProxyRequest;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.ResourceBundle;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class ProxyClient {
    private static OkHttpClient client = new OkHttpClient.Builder().build();
    private static final String HOST;
    private static final int PORT;
    private static final String BASE_URL;

    public static Response requestProxyServer(ProxyRequest request) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(BASE_URL).append("?service=").append(request.getServiceName()).append("&");
        Arrays.stream(request.getClass().getDeclaredFields()).forEach(f -> {
            f.setAccessible(true);
            try {
                if (f.get(request) != null && !Modifier.isStatic(f.getModifiers())) {
                    sb.append(f.getName()).append("=").append(f.get(request)).append("&");
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        });
        Request req = new Request.Builder().url(sb.toString()).build();
        return client.newCall(req).execute();
    }

    static {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("proxy_server");
        HOST = resourceBundle.getString("host");
        PORT = Integer.valueOf(resourceBundle.getString("port"));
        BASE_URL = "http://" + HOST + ":" + PORT;
    }
}

