/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.pay;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xunlei.pay.AbstractProxyResponse;
import com.xunlei.pay.ErrorMsg;
import com.xunlei.pay.ProxyClient;
import com.xunlei.pay.ProxyRequest;
import com.xunlei.pay.ProxyResponse;
import com.xunlei.pay.constant.ResultConstant;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProxyRequest
implements ProxyRequest {
    private static Logger logger = LoggerFactory.getLogger(AbstractProxyRequest.class);
    private static ObjectMapper mapper = new ObjectMapper();

    @Override
    public ProxyResponse request() {
        AbstractProxyResponse response = null;
        try {
            response = this.getResponseClass().newInstance();
            Response r = ProxyClient.requestProxyServer(this);
            Class<? extends AbstractProxyResponse> c = this.getResponseClass();
            return mapper.readValue(r.body().byteStream(), c);
        }
        catch (Exception e) {
            logger.warn("", e);
            try {
                response = this.getResponseClass().newInstance();
                response.setErrorMsg(new ErrorMsg(ResultConstant.SERVER_INTERNAL_ERROR.getCode(), e.getMessage()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return response;
        }
    }

    protected abstract Class<? extends AbstractProxyResponse> getResponseClass();

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

