/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.pay.server;

import com.xunlei.pay.server.BackEndManager;
import com.xunlei.pay.server.DebugLogHandler;
import com.xunlei.pay.server.FrontEndExceptionHandler;
import com.xunlei.pay.server.RequestResolveHandler;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.logging.LoggingHandler;

public class FrontEnd {
    public static final int SOCKET_TIME_OUT = 2000;
    private EventLoopGroup boss;
    private EventLoopGroup worker;
    private ServerBootstrap serverBoot;
    private int port;
    private PooledByteBufAllocator bossAllocator;
    private PooledByteBufAllocator workerAllocator;
    private ChannelInitializer<NioSocketChannel> initializer = new FrontEndChannelInitializer();

    public FrontEnd(int port) {
        this.port = port;
    }

    public void start() {
        new Thread(() -> {
            try {
                this.boss = new NioEventLoopGroup();
                this.worker = new NioEventLoopGroup();
                this.bossAllocator = PooledByteBufAllocator.DEFAULT;
                this.workerAllocator = PooledByteBufAllocator.DEFAULT;
                this.serverBoot = new ServerBootstrap();
                ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)this.serverBoot.group(this.boss, this.worker).channel(NioServerSocketChannel.class)).childHandler(this.initializer).option(ChannelOption.SO_BACKLOG, (Object)1024)).option(ChannelOption.ALLOCATOR, (Object)this.bossAllocator)).option(ChannelOption.SO_TIMEOUT, (Object)2000)).childOption(ChannelOption.AUTO_READ, (Object)false).childOption(ChannelOption.SO_KEEPALIVE, (Object)false).childOption(ChannelOption.ALLOCATOR, (Object)this.workerAllocator);
                ChannelFuture future = this.serverBoot.bind(this.port).sync();
                future.channel().closeFuture().sync();
            }
            catch (Exception exception) {
            }
            finally {
                this.boss.shutdownGracefully();
                this.worker.shutdownGracefully();
                BackEndManager.shutdown();
            }
        }).start();
    }

    public static class FrontEndChannelInitializer
    extends ChannelInitializer<NioSocketChannel> {
        protected void initChannel(NioSocketChannel ch) throws Exception {
            ch.pipeline().addLast(new ChannelHandler[]{new LoggingHandler()});
            ch.pipeline().addLast(new ChannelHandler[]{new DebugLogHandler()});
            ch.pipeline().addLast(new ChannelHandler[]{new HttpServerCodec()});
            ch.pipeline().addLast(new ChannelHandler[]{new FrontEndExceptionHandler()});
            ch.pipeline().addLast(new ChannelHandler[]{new RequestResolveHandler()});
        }
    }
}

