/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.pay.server;

import com.xunlei.pay.config.AccountServiceConfig;
import com.xunlei.pay.config.Environment;
import com.xunlei.pay.server.BackEndExceptionHandler;
import com.xunlei.pay.server.CbinDecodeHandler;
import com.xunlei.pay.server.CbinEncodeHandler;
import com.xunlei.pay.server.DebugLogHandler;
import com.xunlei.pay.server.FrontEndExceptionHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.channel.pool.FixedChannelPool;
import io.netty.channel.pool.SimpleChannelPool;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackEndManager {
    private static int MAX_SIZE;
    private static EventLoopGroup backEndThreadPool;
    private static Bootstrap boot;
    private static SimpleChannelPool pool;
    private static final int TIME_OUT = 2000;
    private static Logger logger;

    public static Future<Channel> getLongConnection() {
        logger.info("getting long connection-------->");
        return pool.acquire();
    }

    public static void releaseConnection(Channel channel) {
        logger.info("release connection-------->");
        if (channel != null) {
            if (Environment.LINK_TYPE == Environment.LinkType.LONG) {
                pool.release(channel);
            } else {
                channel.close();
            }
        }
    }

    public static Channel getShortConnection(EventLoopGroup group, ChannelFutureListener listener) {
        logger.info("getting short connection-------->");
        Bootstrap bootstrap = new Bootstrap();
        ChannelFuture future = ((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new BackEndChannelInitializer())).connect(AccountServiceConfig.HOST, AccountServiceConfig.PORT).addListener((GenericFutureListener)listener);
        return future.channel();
    }

    public static void shutdown() {
        backEndThreadPool.shutdownGracefully();
    }

    static {
        logger = LoggerFactory.getLogger(BackEndManager.class);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("backend");
        MAX_SIZE = Integer.valueOf(resourceBundle.getString("MAX_SIZE"));
        backEndThreadPool = new NioEventLoopGroup();
        boot = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)boot.group(backEndThreadPool)).channel(NioSocketChannel.class)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)2000)).option(ChannelOption.SO_KEEPALIVE, (Object)true);
        boot.remoteAddress((SocketAddress)InetSocketAddress.createUnresolved(AccountServiceConfig.HOST, AccountServiceConfig.PORT));
        pool = new FixedChannelPool(boot, new ChannelPoolHandler(){

            public void channelReleased(Channel channel) throws Exception {
                logger.debug("release a channel");
            }

            public void channelAcquired(Channel channel) throws Exception {
                logger.debug("acquire a channel");
            }

            public void channelCreated(Channel channel) throws Exception {
                logger.debug("create a channel");
                channel.pipeline().addLast(new ChannelHandler[]{new CbinEncodeHandler()});
                channel.pipeline().addLast(new ChannelHandler[]{new CbinDecodeHandler()});
                channel.pipeline().addLast(new ChannelHandler[]{new BackEndExceptionHandler()});
                channel.pipeline().addLast(new ChannelHandler[]{new DebugLogHandler()});
                channel.closeFuture().addListener(f -> pool.release(channel));
            }
        }, MAX_SIZE);
    }

    public static class BackEndChannelInitializer
    extends ChannelInitializer {
        protected void initChannel(Channel channel) throws Exception {
            channel.pipeline().addLast(new ChannelHandler[]{new CbinEncodeHandler()});
            channel.pipeline().addLast(new ChannelHandler[]{new CbinDecodeHandler()});
            channel.pipeline().addLast(new ChannelHandler[]{new FrontEndExceptionHandler()});
            channel.pipeline().addLast(new ChannelHandler[]{new DebugLogHandler()});
        }
    }
}

