/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.pay.server;

import com.xunlei.pay.server.Attributes;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackEndExceptionHandler
extends ChannelDuplexHandler {
    private static Logger logger = LoggerFactory.getLogger(BackEndExceptionHandler.class);

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.warn("", cause);
        this.closeChannel(ctx, cause);
        ctx.fireExceptionCaught(cause);
    }

    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        ctx.connect(remoteAddress, localAddress, promise.addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (!future.isSuccess()) {
                logger.warn("write error#{}", future.cause());
                this.closeChannel(ctx, future.cause());
            }
        })));
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        ctx.write(msg, promise.addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (!future.isSuccess()) {
                logger.warn("write error#{}", future.cause());
                this.closeChannel(ctx, future.cause());
            }
        })));
    }

    private void closeChannel(ChannelHandlerContext ctx, Throwable cause) {
        CompletableFuture future = (CompletableFuture)ctx.channel().attr(Attributes.FUTURE_ATTRIBUTE_KEY).get();
        if (future != null) {
            future.completeExceptionally(cause);
        }
        ctx.close();
    }
}

