/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.pay.request;

import com.xunlei.pay.codec.JSON;
import com.xunlei.pay.request.in.ProxyRequestHandler;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestMapper {
    private static HashMap<String, Class<? extends ProxyRequestHandler>> mapper = new HashMap();
    private static Logger logger = LoggerFactory.getLogger(RequestMapper.class);
    private static final String SERVICE = "service";
    private static final String UTF8 = "utf-8";

    public static Optional<ProxyRequestHandler> mapRequest(String url) throws Exception {
        logger.info("url#{}", (Object)url);
        if (!url.contains("?")) {
            return Optional.empty();
        }
        url = url.substring(url.indexOf("?") + 1, url.length());
        HashMap parmas = new HashMap();
        Arrays.stream(url.split("&")).map(s -> s.split("=")).filter(a -> ((String[])a).length == 2).forEach(a -> parmas.put(a[0], a[1]));
        if (parmas.get(SERVICE) == null) {
            return Optional.empty();
        }
        logger.info("[PARAMETERS] # {}", (Object)JSON.toJSONString(parmas));
        Class<? extends ProxyRequestHandler> handler = mapper.get(parmas.get(SERVICE));
        if (handler == null) {
            return Optional.empty();
        }
        ProxyRequestHandler prh = handler.newInstance();
        Arrays.stream(handler.getDeclaredFields()).forEach(f -> {
            f.setAccessible(true);
            if (parmas.get(f.getName()) != null) {
                String value = (String)parmas.get(f.getName());
                try {
                    f.set(prh, value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        return Optional.of(prh);
    }

    static {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("request");
        for (String url : resourceBundle.keySet()) {
            try {
                Class<?> c = Class.forName(resourceBundle.getString(url));
                mapper.put(url, c);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }
}

