/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.pay.server;

import com.xunlei.pay.config.Environment;
import com.xunlei.pay.constant.ErrorHttpResponse;
import com.xunlei.pay.request.RequestMapper;
import com.xunlei.pay.request.in.ProxyRequestHandler;
import com.xunlei.pay.request.in.dto.ResultConstant;
import com.xunlei.pay.server.Attributes;
import com.xunlei.pay.server.BackEndManager;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestResolveHandler
extends ChannelInboundHandlerAdapter {
    private ChannelHandlerContext channelHandlerContext;
    private static Logger logger = LoggerFactory.getLogger(RequestResolveHandler.class);
    private Channel backEnd;
    private static final String RESULT = "result";

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.channelHandlerContext = ctx;
        if (Environment.LINK_TYPE == Environment.LinkType.LONG) {
            Future<Channel> f2 = BackEndManager.getLongConnection();
            f2.addListener((GenericFutureListener)((FutureListener)channelFuture -> {
                if (channelFuture.isSuccess()) {
                    this.backEnd = (Channel)channelFuture.getNow();
                    this.channelHandlerContext.read();
                } else {
                    logger.warn("failed to connect back end");
                    this.channelHandlerContext.close();
                }
            }));
        } else {
            this.backEnd = BackEndManager.getShortConnection((EventLoopGroup)ctx.channel().eventLoop(), f -> {
                if (f.isSuccess()) {
                    this.channelHandlerContext.read();
                } else {
                    logger.warn("failed to connect back end");
                    this.channelHandlerContext.close();
                }
            });
        }
        ctx.channel().closeFuture().addListener(future -> BackEndManager.releaseConnection(this.backEnd));
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpRequest) {
            HttpRequest request = (HttpRequest)msg;
            String uri = request.uri();
            Optional<ProxyRequestHandler> r = RequestMapper.mapRequest(uri);
            if (r.isPresent()) {
                ProxyRequestHandler handler = r.get();
                CompletableFuture completableFuture = new CompletableFuture();
                this.backEnd.attr(Attributes.FUTURE_ATTRIBUTE_KEY).set(completableFuture);
                this.backEnd.eventLoop().submit(() -> this.backEnd.writeAndFlush((Object)handler.getOutRequest()).addListener(channelFuture -> {
                    if (!channelFuture.isSuccess()) {
                        ctx.close();
                    }
                }));
                completableFuture.whenComplete((m, t) -> {
                    DefaultFullHttpResponse response;
                    if (m != null && t == null) {
                        try {
                            String proxyResponse = handler.convert2ProxyResponseJSON((Map<String, String>)m);
                            logger.info(proxyResponse);
                            response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])proxyResponse.getBytes("utf-8")));
                            response.headers().set("Content-Type", (Object)"application/json");
                            response.headers().setInt((CharSequence)"Content-Length", response.content().readableBytes());
                            if (ResultConstant.REQ_PARM_ILLEGAL.getCode().equals(m.get(RESULT))) {
                                logger.warn("get 403 response, close backend channel for safety policy");
                                this.backEnd.close();
                            }
                        }
                        catch (Exception e) {
                            response = ErrorHttpResponse.SERVICE_UNAVAILABLE();
                            logger.error("", (Throwable)e);
                        }
                    } else {
                        logger.warn("complete error#{}", t);
                        response = ErrorHttpResponse.SERVICE_UNAVAILABLE();
                    }
                    this.write((HttpResponse)response);
                });
            } else {
                logger.debug("[Closing Channel] can't resolve request");
                ctx.close();
            }
        }
    }

    private void write(HttpResponse response) {
        if (this.channelHandlerContext.channel().eventLoop().inEventLoop()) {
            this.channelHandlerContext.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            this.channelHandlerContext.channel().eventLoop().submit(() -> this.channelHandlerContext.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE));
        }
    }
}

