/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.pay.server;

import com.xunlei.pay.codec.RequestCodec;
import com.xunlei.pay.server.Attributes;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbinDecodeHandler
extends ByteToMessageDecoder {
    private static Logger logger = LoggerFactory.getLogger(CbinDecodeHandler.class);

    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Exception {
        if (byteBuf.readableBytes() > 4) {
            int len = byteBuf.getInt(0);
            if (byteBuf.readableBytes() >= len) {
                byte[] data = new byte[len];
                byteBuf.readBytes(data);
                Map<String, String> fields = RequestCodec.decode(data);
                list.add(fields);
                CompletableFuture future = (CompletableFuture)channelHandlerContext.channel().attr(Attributes.FUTURE_ATTRIBUTE_KEY).get();
                if (future != null) {
                    future.complete(fields);
                } else {
                    logger.warn("null future!");
                    channelHandlerContext.channel().close();
                }
            }
        }
    }
}

