/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.pay.codec;

import com.xunlei.pay.annotation.Ignore;
import com.xunlei.pay.annotation.Serialize;
import com.xunlei.pay.codec.JSON;
import com.xunlei.pay.request.out.AccountInfoRequest;
import com.xunlei.pay.request.out.GetUserBaseInfo;
import com.xunlei.pay.request.out.GetUserInfo;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestCodec {
    private static Charset GBK = Charset.forName("GBK");
    private static Charset UTF8 = Charset.forName("UTF-8");
    private static String utf8 = "utf-8";
    private static int LENGTH_FIELD_SIZE = 4;
    private static Logger logger = LoggerFactory.getLogger(RequestCodec.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] encode(AccountInfoRequest request) {
        Field[] fields = request.getClass().getDeclaredFields();
        ByteBuf row = PooledByteBufAllocator.DEFAULT.buffer();
        ByteBuf record = PooledByteBufAllocator.DEFAULT.buffer();
        try {
            Arrays.stream(fields).filter(f -> f.getAnnotation(Ignore.class) == null).map(f -> {
                ByteBuf byteBuf = PooledByteBufAllocator.DEFAULT.buffer();
                try {
                    String v2;
                    Charset cha;
                    String name;
                    block9: {
                        f.setAccessible(true);
                        Serialize serialize = f.getAnnotation(Serialize.class);
                        if (serialize != null && !"".equals(serialize.name())) {
                            name = serialize.name();
                            cha = Charset.forName(serialize.charset());
                        } else {
                            name = f.getName();
                            cha = GBK;
                        }
                        v2 = (String)f.get(request);
                        if (v2 != null) break block9;
                        byte[] byArray = null;
                        return byArray;
                    }
                    try {
                        byte[] nameb = name.getBytes(cha);
                        byte[] valueb = v2.getBytes(cha);
                        byteBuf.writeInt(nameb.length).writeBytes(nameb).writeInt(valueb.length).writeBytes(valueb);
                    }
                    catch (IllegalAccessException v2) {
                        // empty catch block
                    }
                    byte[] field = new byte[byteBuf.readableBytes()];
                    byteBuf.readBytes(field);
                    byte[] byArray = field;
                    return byArray;
                }
                finally {
                    byteBuf.release();
                }
            }).forEach(b -> {
                if (b != null) {
                    row.writeInt(((byte[])b).length).writeBytes(b);
                }
            });
            int rowLen = row.readableBytes();
            record.writeInt(rowLen + LENGTH_FIELD_SIZE * 2).writeInt(rowLen).writeBytes(row);
            int recordLen = record.readableBytes();
            byte[] data = new byte[recordLen];
            record.readBytes(data);
            if (logger.isDebugEnabled()) {
                logger.debug("size#{},hexDump{}", (Object)data.length, (Object)ByteBufUtil.hexDump((byte[])data));
            }
            byte[] byArray = data;
            return byArray;
        }
        catch (Exception e) {
            logger.warn("", (Throwable)e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            record.release();
            row.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> decode(byte[] bytes) {
        HashMap<String, String> fields = new HashMap<String, String>();
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])bytes);
        try {
            int len = byteBuf.readInt();
            logger.debug("record len#" + len);
            int rowlen = byteBuf.readInt();
            logger.debug("row len#" + rowlen);
            ByteBuf row = byteBuf.readSlice(rowlen);
            while (row.readableBytes() != 0) {
                int fieldLen = row.readInt();
                ByteBuf field = row.readSlice(fieldLen);
                int nameLen = field.readInt();
                byte[] nb = new byte[nameLen];
                field.readBytes(nb);
                String name = new String(nb, GBK);
                int valueLen = field.readInt();
                byte[] vb = new byte[valueLen];
                field.readBytes(vb);
                String value = null;
                value = "sig".equals(name) || "unickname".equals(name) ? new String(vb, UTF8) : new String(vb, GBK);
                fields.put(name, value);
            }
            logger.info(JSON.toJSONString(fields));
            HashMap<String, String> hashMap = fields;
            return hashMap;
        }
        finally {
            byteBuf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void send(String host, int port, int timeout) {
        Socket client = null;
        DataInputStream in = null;
        DataOutputStream out = null;
        boolean resultOk = false;
        try {
            int nRead;
            client = new Socket(host, port);
            client.setSoTimeout(timeout);
            out = new DataOutputStream(client.getOutputStream());
            byte[] buffer = RequestCodec.encode(new GetUserInfo("69551120", "2"));
            ((OutputStream)out).write(buffer);
            ((OutputStream)out).flush();
            in = new DataInputStream(client.getInputStream());
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            byte[] data = new byte[16384];
            while ((nRead = in.read(data, 0, data.length)) != -1) {
                b.write(data, 0, nRead);
            }
            b.flush();
            byte[] bb = b.toByteArray();
            logger.debug("before decode response: {}", (Object)in.toString());
            RequestCodec.decode(bb);
        }
        catch (Exception e) {
            logger.error("send com.xunlei.pay.request error, msg: {}", (Throwable)e);
        }
        finally {
            if (client != null) {
                try {
                    client.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void main(String[] args) {
        RequestCodec.encode(new GetUserBaseInfo("67551220", null));
    }
}

