/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.pay.codec;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSON {
    private static ObjectMapper mapper;
    private static Logger logger;

    public static String toJSONString(Object o) {
        try {
            return mapper.writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            logger.warn("", (Throwable)e);
            return null;
        }
    }

    public static <T> T toJavaObject(Map map, Class<T> c) {
        return (T)mapper.convertValue((Object)map, c);
    }

    public static <T> T toJavaObject(String json, Class<T> c) {
        try {
            return (T)mapper.readValue(json, c);
        }
        catch (IOException e) {
            logger.warn("", (Throwable)e);
            return null;
        }
    }

    public static <T> T toJavaObject(InputStream in, Class<T> c) {
        try {
            return (T)mapper.readValue(in, c);
        }
        catch (IOException e) {
            logger.warn("", (Throwable)e);
            return null;
        }
    }

    public static <T> T toJavaObject(InputStream in, TypeReference typeReference) {
        try {
            return (T)mapper.readerFor(typeReference).readValue(in);
        }
        catch (IOException e) {
            logger.warn("", (Throwable)e);
            return null;
        }
    }

    static {
        logger = LoggerFactory.getLogger(JSON.class);
        mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    private static class Test {
        private String name;
        private String age;

        public Test() {
        }

        public Test(String name, String age) {
            this.name = name;
            this.age = age;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getAge() {
            return this.age;
        }

        public void setAge(String age) {
            this.age = age;
        }
    }
}

