/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.pay.server;

import com.xunlei.pay.constant.ErrorHttpResponse;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrontEndExceptionHandler
extends ChannelDuplexHandler {
    private static Logger logger = LoggerFactory.getLogger(FrontEndExceptionHandler.class);

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.warn("", cause);
        ctx.writeAndFlush((Object)ErrorHttpResponse.SERVICE_UNAVAILABLE()).addListener(f -> ctx.close());
        ctx.fireExceptionCaught(cause);
    }

    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        ctx.connect(remoteAddress, localAddress, promise.addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (!future.isSuccess()) {
                logger.warn("write error#{}", (Object)future);
                ctx.writeAndFlush((Object)ErrorHttpResponse.SERVICE_UNAVAILABLE()).addListener(f -> ctx.close());
            }
        })));
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        ctx.write(msg, promise.addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (!future.isSuccess()) {
                logger.warn("write error#{}", (Object)future);
                ctx.writeAndFlush((Object)ErrorHttpResponse.SERVICE_UNAVAILABLE()).addListener(f -> ctx.close());
            }
        })));
    }
}

