package com.xunlei.emoticon.mall.web.admin;

import com.google.common.base.MoreObjects;
import com.xunlei.emoticon.mall.constant.CommonConstant;
import com.xunlei.emoticon.mall.domain.SlideShow;
import com.xunlei.emoticon.mall.dto.Return;
import com.xunlei.emoticon.mall.repository.SlideShowRepository;
import com.xunlei.emoticon.mall.service.AdminService;
import com.xunlei.emoticon.mall.util.BeanUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Shunli
 */
@RestController
@RequestMapping("/admin/slide-shows")
public class SlideShowsController {
    @Autowired
    private SlideShowRepository slideShowRepository;
    @Autowired
    private AdminService adminService;

    @GetMapping
    public Return getSlideShows(@RequestParam Long channelId,
                                @PageableDefault(sort = {"enabled", "priority", "lastModifiedDate"}, direction = Sort.Direction.DESC) Pageable pageable) {
        return CommonConstant.SUCCESS_RETURN.result(slideShowRepository.findByChannelId(channelId, pageable));
    }

    @GetMapping("/{id}")
    public Return getSlideShow(@PathVariable Long id) {
        return CommonConstant.SUCCESS_RETURN.result(slideShowRepository.findOne(id));
    }

    @RequestMapping(method = {RequestMethod.POST, RequestMethod.PUT})
    public Return saveSlideShow(@RequestBody SlideShow slideShow) {
        slideShow.setEnabled(MoreObjects.firstNonNull(slideShow.getEnabled(), false));
        slideShow.setPriority(MoreObjects.firstNonNull(slideShow.getPriority(), CommonConstant.DEFAULT_PRIORITY));

        return CommonConstant.SUCCESS_RETURN.result(slideShowRepository.save(slideShow));
    }

    @PatchMapping("/{id}")
    public Return patchSlideShow(@PathVariable Long id, @RequestBody SlideShow patch) {
        SlideShow slideShow = slideShowRepository.findOne(id);
        if (slideShow == null) {
            return CommonConstant.FAILED_RETURN.msg("ID为" + id + "的轮播图不存在");
        }

        BeanUtil.copyPropertiesSkipNullProperties(patch, slideShow);
        return CommonConstant.SUCCESS_RETURN.result(slideShowRepository.save(slideShow));
    }

}
