package com.xunlei.emoticon.mall.web.admin;

import com.xunlei.emoticon.mall.constant.CommonConstant;
import com.xunlei.emoticon.mall.domain.Authority;
import com.xunlei.emoticon.mall.domain.User;
import com.xunlei.emoticon.mall.dto.Return;
import com.xunlei.emoticon.mall.service.ManagementService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author Shunli
 */
@RestController
@RequestMapping("/admin/management")
public class ManagementController {
    @Autowired
    private ManagementService managementService;

    @PostMapping(value = "/users")
    public Return saveUser(@RequestBody User user) {
        return CommonConstant.SUCCESS_RETURN.result(managementService.saveUser(user));
    }

    @DeleteMapping(value = "/users/{username}")
    public Return deleteUser(@PathVariable String username) {
        return CommonConstant.SUCCESS_RETURN.result(managementService.deleteUser(username));
    }

    @PostMapping(value = "/authorities")
    public Return saveAuthorities(@RequestBody List<Authority> authorities) {
        return CommonConstant.SUCCESS_RETURN.result(managementService.saveAuthorities(authorities));
    }

    @DeleteMapping(value = "/authorities/{username}")
    public Return deleteAuthorities(@PathVariable String username) {
        return CommonConstant.SUCCESS_RETURN.result(managementService.deleteAuthorities(username));
    }

    @DeleteMapping(value = "/authorities/{username}/{authority}")
    public Return deleteAuthority(@PathVariable String username, @PathVariable String authority) {
        return CommonConstant.SUCCESS_RETURN.result(managementService.deleteAuthority(username, authority));
    }
}
