package com.xunlei.emoticon.mall.web.admin;

// import com.google.common.io.Files;

// import com.google.common.io.Files;

import com.xunlei.emoticon.mall.constant.CommonConstant;
import com.xunlei.emoticon.mall.dto.Return;
import com.xunlei.emoticon.mall.service.AdminService;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import java.io.ByteArrayInputStream;
import java.io.IOException;

/**
 * @author Shunli
 */
@RestController
@RequestMapping("/admin/images")
public class ImagesController {
    @Autowired
    private AdminService adminService;

    @PostMapping
    public Return upload(@RequestParam MultipartFile file) throws IOException {
        if (!StringUtils.startsWithIgnoreCase(file.getContentType(), "image")) {
            return CommonConstant.FAILED_RETURN.msg("只支持图片上传");
        }

        String url = adminService.saveImg(FilenameUtils.getExtension(file.getOriginalFilename()), new ByteArrayInputStream(file.getBytes()));
        return CommonConstant.SUCCESS_RETURN.result(url);
    }

}
