package com.xunlei.emoticon.mall.web.admin;

import com.xunlei.emoticon.mall.constant.CommonConstant;
import com.xunlei.emoticon.mall.domain.Feedback;
import com.xunlei.emoticon.mall.dto.Return;
import com.xunlei.emoticon.mall.repository.FeedbackRepository;
import com.xunlei.emoticon.mall.util.BeanUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Shunli
 */
@RestController
@RequestMapping("/admin/feedback")
public class FeedbackController {
    @Autowired
    private FeedbackRepository feedbackRepository;

    @GetMapping
    public Return getFeedback(@RequestParam Long channelId, @PageableDefault(sort = {"archived", "createdDate"}) Pageable pageable) {
        return CommonConstant.SUCCESS_RETURN.result(feedbackRepository.findByChannelId(channelId, pageable));
    }

    @PatchMapping("/{id}")
    public Return patchFeedback(@PathVariable Long id, @RequestBody Feedback feedback) {
        Feedback one = feedbackRepository.findOne(id);
        if (one == null) return null;

        BeanUtil.copyPropertiesSkipNullProperties(feedback, one);
        feedbackRepository.save(one);

        return CommonConstant.SUCCESS_RETURN.result(one);
    }

}
