package com.xunlei.emoticon.mall.web.admin;

import com.google.common.base.MoreObjects;
import com.xunlei.emoticon.mall.constant.CommonConstant;
import com.xunlei.emoticon.mall.domain.Emoticon;
import com.xunlei.emoticon.mall.dto.EmoticonEnabledDto;
import com.xunlei.emoticon.mall.dto.Return;
import com.xunlei.emoticon.mall.repository.EmoticonRepository;
import com.xunlei.emoticon.mall.service.AdminService;
import com.xunlei.emoticon.mall.util.BeanUtil;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;

/**
 * @author Shunli
 */
@RestController
@RequestMapping("/admin/emoticons")
public class EmoticonsController {
    @Autowired
    private EmoticonRepository emoticonRepository;
    @Autowired
    private AdminService adminService;

    @GetMapping
    public Return getEmoticons(@RequestParam Long channelId, @RequestParam Long emoticonPackId,
                               @PageableDefault(sort = {"enabled", "priority", "lastModifiedDate"}, direction = Sort.Direction.DESC) Pageable pageable) {
        return CommonConstant.SUCCESS_RETURN.result(emoticonRepository.findByChannelIdAndEmoticonPackId(channelId, emoticonPackId, pageable));
    }

    @GetMapping("/search")
    public Return searchEmoticons(@RequestParam Long channelId, @RequestParam(required = false) Boolean isGIF, @RequestParam(required = false) Boolean enabled,
                                  @PageableDefault(sort = {"priority", "lastModifiedDate"}, direction = Sort.Direction.DESC) Pageable pageable) {
        return CommonConstant.SUCCESS_RETURN.result(emoticonRepository.search(channelId, isGIF, enabled, pageable));
    }

    @GetMapping("/{id}")
    public Return getEmoticon(@PathVariable Long id) {
        return CommonConstant.SUCCESS_RETURN.result(emoticonRepository.findOne(id));
    }

    @PostMapping
    public Return uploadEmoticon(@RequestParam Long channelId, @RequestParam(required = false) Long emoticonPackId,
                                 @RequestParam MultipartFile file) throws IOException {
        if (!StringUtils.startsWithIgnoreCase(file.getContentType(), "image") &&
                !StringUtils.equalsIgnoreCase("zip", FilenameUtils.getExtension(file.getOriginalFilename()))) {
            return CommonConstant.FAILED_RETURN.msg("只支持图片或者zip压缩包");
        }

        return CommonConstant.SUCCESS_RETURN.msg(adminService.uploadEmoticon(channelId, emoticonPackId, file));
    }

    @PutMapping
    public Return updateEmoticon(@RequestBody Emoticon emoticon) {
        return CommonConstant.SUCCESS_RETURN.result(emoticonRepository.save(emoticon));
    }

    @PatchMapping("/{id}")
    public Return patchEmoticon(@PathVariable Long id, @RequestBody Emoticon emoticon) {
        Emoticon one = emoticonRepository.findOne(id);
        if (one == null) return null;

        BeanUtil.copyPropertiesSkipNullProperties(emoticon, one);
        emoticonRepository.save(one);

        return CommonConstant.SUCCESS_RETURN.result(one);
    }

    @PatchMapping
    public Return enabledEmoticons(@RequestBody EmoticonEnabledDto emoticonEnabledDto) {
        Iterable<Emoticon> emoticons = emoticonRepository.findAll(emoticonEnabledDto.getIds());
        emoticons.forEach(emoticon -> emoticon.setEnabled(MoreObjects.firstNonNull(emoticonEnabledDto.getEnabled(), false)));
        emoticonRepository.save(emoticons);

        return CommonConstant.SUCCESS_RETURN;
    }
}
