package com.xunlei.emoticon.mall.web.admin;

import com.google.common.base.MoreObjects;
import com.xunlei.emoticon.mall.constant.CommonConstant;
import com.xunlei.emoticon.mall.domain.Emoticon;
import com.xunlei.emoticon.mall.domain.EmoticonPack;
import com.xunlei.emoticon.mall.dto.Return;
import com.xunlei.emoticon.mall.repository.EmoticonPackRepository;
import com.xunlei.emoticon.mall.repository.EmoticonRepository;
import com.xunlei.emoticon.mall.util.BeanUtil;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author Shunli
 */
@RestController
@RequestMapping("/admin/emoticon-packs")
public class EmoticonPacksController {
    @Autowired
    private EmoticonPackRepository emoticonPackRepository;
    @Autowired
    private EmoticonRepository emoticonRepository;

    @GetMapping
    public Return getEmoticonPacks(@RequestParam Long channelId,
                                   @PageableDefault(sort = {"enabled", "recommended", "priority", "lastModifiedDate"}, direction = Sort.Direction.DESC) Pageable pageable) {
        return CommonConstant.SUCCESS_RETURN.result(emoticonPackRepository.findByChannelId(channelId, pageable));
    }

    @GetMapping("/{id}")
    public Return getEmoticonPack(@PathVariable Long id) {
        return CommonConstant.SUCCESS_RETURN.result(emoticonPackRepository.findOne(id));
    }

    @RequestMapping(method = {RequestMethod.POST, RequestMethod.PUT})
    public Return saveEmoticonPack(@RequestBody EmoticonPack emoticonPack) {
        emoticonPack.setEnabled(MoreObjects.firstNonNull(emoticonPack.getEnabled(), false));
        emoticonPack.setRecommended(MoreObjects.firstNonNull(emoticonPack.getRecommended(), false));
        emoticonPack.setPriority(MoreObjects.firstNonNull(emoticonPack.getPriority(), CommonConstant.DEFAULT_PRIORITY));

        return CommonConstant.SUCCESS_RETURN.result(emoticonPackRepository.save(emoticonPack));
    }

    @PatchMapping("/{id}")
    public Return patchEmoticonPack(@PathVariable Long id, @RequestBody EmoticonPack patch) {
        // 取消发布需要取消推荐
        if (!BooleanUtils.toBooleanDefaultIfNull(patch.getEnabled(), true)) {
            patch.setRecommended(false);
        }

        EmoticonPack emoticonPack = emoticonPackRepository.findOne(id);
        if (emoticonPack == null) {
            return CommonConstant.FAILED_RETURN.msg("ID为" + id + "的表情包不存在");
        }

        BeanUtil.copyPropertiesSkipNullProperties(patch, emoticonPack);

        // 推荐需要发布（如果已经发布的话就不需要了）
        if (BooleanUtils.toBoolean(patch.getRecommended())) {
            if (!MoreObjects.firstNonNull(emoticonPack.getEnabled(), false)) {
                patch.setEnabled(true);
            }
            emoticonPack.setEnabled(true);
        }

        // 表情包操作要关联到包下所有表情
        if (patch.getEnabled() != null) {
            List<Emoticon> emoticons = emoticonRepository.findByEmoticonPackId(id)
                    .peek(emoticon -> emoticon.setEnabled(patch.getEnabled()))
                    .collect(Collectors.toList());

            emoticonRepository.save(emoticons);
        }

        return CommonConstant.SUCCESS_RETURN.result(emoticonPackRepository.save(emoticonPack));
    }

}
