package com.xunlei.emoticon.mall.web.admin;

import com.google.common.base.MoreObjects;
import com.xunlei.emoticon.mall.constant.CommonConstant;
import com.xunlei.emoticon.mall.domain.Configuration;
import com.xunlei.emoticon.mall.dto.Return;
import com.xunlei.emoticon.mall.repository.ConfigurationRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Shunli
 */
@RestController
@RequestMapping("/admin/configurations")
public class ConfigurationsController {
    @Autowired
    private ConfigurationRepository configurationRepository;

    @GetMapping
    public Return getConfiguration(@RequestParam Long channelId) {
        Configuration configuration = configurationRepository.findByChannelId(channelId).orElse(new Configuration());
        return CommonConstant.SUCCESS_RETURN.result(configuration);
    }

    @RequestMapping(method = {RequestMethod.POST, RequestMethod.PUT})
    public Return saveConfiguration(@RequestBody Configuration configuration) {
        configuration.setRandomQty(MoreObjects.firstNonNull(configuration.getRandomQty(), 9));
        configuration.setDownloaded(MoreObjects.firstNonNull(configuration.getDownloaded(), false));

        return CommonConstant.SUCCESS_RETURN.result(configurationRepository.save(configuration));
    }

}
