package com.xunlei.emoticon.mall.web.admin;

import com.google.common.base.MoreObjects;
import com.xunlei.emoticon.mall.constant.CommonConstant;
import com.xunlei.emoticon.mall.domain.Channel;
import com.xunlei.emoticon.mall.dto.Return;
import com.xunlei.emoticon.mall.repository.ChannelRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Shunli
 */
@RestController
@RequestMapping("/admin/channels")
public class ChannelsController {
    @Autowired
    private ChannelRepository channelRepository;

    @GetMapping
    public Return getChannels(@PageableDefault(sort = {"enabled", "lastModifiedDate"}, direction = Sort.Direction.DESC) Pageable pageable) {
        return CommonConstant.SUCCESS_RETURN.result(channelRepository.findAll(pageable));
    }

    @GetMapping("/{id}")
    public Return getChannel(@PathVariable Long id) {
        return CommonConstant.SUCCESS_RETURN.result(channelRepository.findOne(id));
    }

    @GetMapping("/enabled")
    public Return getEnabledChannels() {
        return CommonConstant.SUCCESS_RETURN.result(channelRepository.findByEnabledTrue());
    }

    @RequestMapping(method = {RequestMethod.POST, RequestMethod.PUT})
    public Return saveChannel(@RequestBody Channel channel) {
        channel.setEnabled(MoreObjects.firstNonNull(channel.getEnabled(), true));

        return CommonConstant.SUCCESS_RETURN.result(channelRepository.save(channel));
    }

}
