package com.xunlei.emoticon.mall.web.admin;

import com.xunlei.emoticon.mall.constant.CommonConstant;
import com.xunlei.emoticon.mall.domain.Ad;
import com.xunlei.emoticon.mall.domain.AdImage;
import com.xunlei.emoticon.mall.dto.AdWrapper;
import com.xunlei.emoticon.mall.dto.Return;
import com.xunlei.emoticon.mall.repository.AdImageRepository;
import com.xunlei.emoticon.mall.repository.AdRepository;
import com.xunlei.emoticon.mall.util.BeanUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author Shunli
 */
@RestController
@RequestMapping("/admin/ads")
public class AdsController {
    @Autowired
    private AdRepository adRepository;
    @Autowired
    private AdImageRepository adImageRepository;

    @GetMapping
    public Return getAds(@RequestParam Long channelId,
                         @PageableDefault(sort = {"enabled", "lastModifiedDate"}, direction = Sort.Direction.DESC) Pageable pageable) {
        return CommonConstant.SUCCESS_RETURN.result(adRepository.findByChannelId(channelId, pageable));
    }

    @GetMapping("/{id}")
    public Return getAd(@PathVariable Long id) {
        return CommonConstant.SUCCESS_RETURN.result(new AdWrapper(adRepository.findOne(id), adImageRepository.findByAdId(id)));
    }

    @RequestMapping(method = {RequestMethod.POST, RequestMethod.PUT})
    public Return saveAd(@RequestBody AdWrapper adWrapper) {
        Ad ad = adRepository.save(adWrapper.getAd());

        List<AdImage> adImages = adWrapper.getAdImages();
        adImages.forEach(adImage -> adImage.setAd(ad));

        adImageRepository.save(adImages);

        return CommonConstant.SUCCESS_RETURN;
    }

    @PatchMapping("/{id}")
    public Return patchAd(@PathVariable Long id, @RequestBody Ad ad) {
        Ad one = adRepository.findOne(id);
        if (one == null) return null;

        BeanUtil.copyPropertiesSkipNullProperties(ad, one);
        adRepository.save(one);

        return CommonConstant.SUCCESS_RETURN.result(one);
    }

    @PatchMapping("/images/{id}")
    public Return patchAdImage(@PathVariable Long id, @RequestBody AdImage adImage) {
        AdImage one = adImageRepository.findOne(id);
        if (one == null) return null;

        BeanUtil.copyPropertiesSkipNullProperties(adImage, one);
        adImageRepository.save(one);

        return CommonConstant.SUCCESS_RETURN.result(one);
    }
}
