package com.xunlei.emoticon.mall.service;

import com.google.common.collect.ImmutableList;
import com.xunlei.emoticon.mall.constant.CommonConstant;
import com.xunlei.emoticon.mall.domain.Authority;
import com.xunlei.emoticon.mall.domain.User;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.provisioning.JdbcUserDetailsManager;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author Shunli
 */
@Service
@Slf4j
public class ManagementService {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Autowired
    private PasswordEncoder passwordEncoder;

    public int saveUser(User user) {
        String username = user.getUsername();
        boolean enabled = BooleanUtils.toBoolean(user.getEnabled());

        List<String> users = jdbcTemplate.queryForList(JdbcUserDetailsManager.DEF_USER_EXISTS_SQL, String.class, username);
        if (users.size() > 0) {
            if (StringUtils.isEmpty(user.getPassword())) {
                return jdbcTemplate.update("update users set enabled = ? where username = ?", enabled, username);
            }

            return jdbcTemplate.update(JdbcUserDetailsManager.DEF_UPDATE_USER_SQL, passwordEncoder.encode(user.getPassword()), enabled, username);
        }

        int created = jdbcTemplate.update(JdbcUserDetailsManager.DEF_CREATE_USER_SQL, username, passwordEncoder.encode(user.getPassword()), enabled);

        // add default authority USER
        saveAuthorities(ImmutableList.of(new Authority(username, CommonConstant.USER_AUTHORITY)));

        return created;
    }

    public int deleteUser(String username) {
        return jdbcTemplate.update(JdbcUserDetailsManager.DEF_DELETE_USER_SQL, username);
    }

    public int saveAuthorities(List<Authority> authorities) {
        int i = 0;
        for (Authority authority : authorities) {
            try {
                i = i + jdbcTemplate.update(JdbcUserDetailsManager.DEF_INSERT_AUTHORITY_SQL, authority.getUsername(),
                        StringUtils.prependIfMissing(StringUtils.upperCase(authority.getAuthority()), "ROLE_"));
            } catch (DataAccessException e) {
                log.error("saveAuthorities failed: " + authorities, e);
            }
        }
        return i;
    }

    public int deleteAuthorities(String username) {
        return jdbcTemplate.update(JdbcUserDetailsManager.DEF_DELETE_USER_AUTHORITIES_SQL, username);
    }

    public int deleteAuthority(String username, String authority) {
        return jdbcTemplate.update("delete from authorities where username = ? and authority = ?", username, authority);
    }
}
