package com.xunlei.emoticon.mall.service;

import com.xunlei.emoticon.mall.constant.CommonConstant;
import com.xunlei.emoticon.mall.dto.Return;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

import javax.servlet.http.HttpServletRequest;

/**
 * @author Shunli
 */
@Slf4j
@ControllerAdvice
public class ExceptionControllerAdvice extends ResponseEntityExceptionHandler {
    @ExceptionHandler
    @ResponseBody
    public Return handleControllerException(HttpServletRequest request, Throwable ex) {
        // api maybe different with admin service, admin can throw exceptions info.
        logger.error(request.getRequestURL().toString(), ex);
        return CommonConstant.FAILED_RETURN.msg("网络异常，请稍后重试");
    }

}