package com.xunlei.emoticon.mall.repository;

import com.xunlei.emoticon.mall.domain.SlideShow;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.PagingAndSortingRepository;

import java.util.stream.Stream;

/**
 * @author Shunli
 */
public interface SlideShowRepository extends PagingAndSortingRepository<SlideShow, Long> {
    Stream<SlideShow> findByChannelIdAndEnabledTrue(Long channelId, Sort sort);

    Page<SlideShow> findByChannelId(Long channelId, Pageable pageable);
}
